<?
/**

 * @name MP3Tool class
 * @author SkyFire aka XeOn
 * @icq 2666440
 * @readme readme.txt
 * @copyright (c)2012 SkyTech :)
 * @modded Ulty aka Samad
 * @mail samad.d@mail.ru
**/

class MP3Tool {
    private static $root;
    private static $includePath;
        
    /**
     * Получаем расширение файла
    **/
    
    private function ext($filepath)
    {
        $ext = pathinfo($filepath, PATHINFO_EXTENSION);
        return $ext;
    }
    function antilink($var)
    {
        $replace = array(
            '.ru' => '',
            '.com' => '',
            '.biz' => '',
            '.cn' => '',
            '.in' => '',
            '.net' => '',
            '.org' => '',
            '.info' => '',
            '.mobi' => '',
            '.wen' => '',
            '.kmx' => '',
            '.h2m' => '',
            '.uz' => '',
            '.ulty' => '',
            '.lark' => '',
            '.keo' => ''
        );
        return strtr($var, $replace);
    }
    /**
     * Конструктор класса
    **/
    function mp3info()
	{
		$byte 			= array();
		$version 		= array("MPEG Version 2.5",false,"MPEG Version 2 (ISO/IEC 13818-3)","MPEG Version 1 (ISO/IEC 11172-3)");
		$version_bitrate	= array(1,false,1,0);
		$version_sampling	= array(2,false,1,0);
		$layer			= array(false,"Layer III","Layer II","Layer I");
		$layer_bitrate		= array(false,2,1,0);
		$layer_lengt		= array(false,1,1,0);
		$protection 		= array("Protected by CRC (16bit crc follows header)","Not protected");
		$byterate		= array(
						array(
							array("free",32,64,96,128,160,192,224,256,288,320,352,384,416,448,"bad"),
							array("free",32,48,56, 64, 80, 96,112,128,160,192,224,256,320,384,"bad"),
							array("free",32,40,48, 56, 64, 80, 96,112,128,160,192,224,256,320,"bad")
						     ),
						array(
							array("free",32,48,56, 64, 80, 96,112,128,144,160,176,192,224,256,"bad"),
							array("free", 8,16,24, 32, 40, 48, 56, 64, 80, 96,112,128,144,160,"bad"),
							array("free", 8,16,24, 32, 40, 48, 56, 64, 80, 96,112,128,144,160,"bad")
						     )
					       );
		$samplingrate		= array(
						array(44100,48000,32000,false),
						array(22050,24000,16000,false),
						array(11025,12000, 8000,false)
					       );
		$cannel_mode	= array("Stereo","Joint stereo (Stereo)","Dual channel (Stereo)","Single channel (Mono)");
		$copyright	= array("Audio is not copyrighted","Audio is copyrighted ");
		$original	= array("Copy of original media","Original media");
		$emphasis	= array("none","50/15 ms",false,"CCIT J.17 ");

	//id3-stuff

	$genre			= array
					("Blues","Classic Rock","Country","Dance","Disco","Funk","Grunge","Hip-Hop","Jazz","Metal","New Age","Oldies","Other","Pop","R&amp;B",
					"Rap","Reggae","Rock","Techno","Industrial","Alternative","Ska","Death Metal","Pranks","Soundtrack","Euro-Techno","Ambient","Trip-Hop",
					"Vocal","Jazz+Funk","Fusion","Trance","Classical","Instrumental","Acid","House","Game","Sound Clip","Gospel","Noise","Alternative Rock",
					"Bass","Soul","Punk","Space","Meditative","Instrumental Pop","Instrumental Rock","Ethnic","Gothic","Darkwave","Techno-Industrial",
					"Electronic","Pop-Folk","Eurodance","Dream","Southern Rock","Comedy","Cult","Gangsta","Top 40","Christian Rap","Pop/Funk","Jungle",
					"Native US","Cabaret","New Wave","Psychadelic","Rave","Showtunes","Trailer","Lo-Fi","Tribal","Acid Punk","Acid Jazz","Polka","Retro",
					"Musical","Rock & Roll","Hard Rock","Folk","Folk-Rock","National Folk","Swing","Fast Fusion","Bebob","Latin","Revival","Celtic","Bluegrass",
					"Avantgarde","Gothic Rock","Progressive Rock","Psychedelic Rock","Symphonic Rock","Slow Rock","Big Band","Chorus","Easy Listening","Acoustic",
					"Humour","Speech","Chanson","Opera","Chamber Music","Sonata","Symphony","Booty Bass","Primus","Porn Groove","Satire","Slow Jam","Club",
					"Tango","Samba","Folklore","Ballad","Power Ballad","Rhytmic Soul","Freestyle","Duet","Punk Rock","Drum Solo","Acapella","Euro-House",
					"Dance Hall","Goa","Drum & Bass","Club-House","Hardcore","Terror","Indie","BritPop","Negerpunk","Polsk Punk","Beat","Christian Gangsta Rap",
					"Heavy Metal","Black Metal","Crossover","Contemporary Christian","Christian Rock","Merengue","Salsa","Trash Metal","Anime","Jpop","Synthpop");

	//id3v2 check----------------------------

		$footer = 0;
		$header = 0;
		$v1tag	= 0;
		$fp = fopen($this->wave_filename,"r");
		$tmp = fread($fp,3);
		if($tmp == "ID3")
		{
			$tmp 	= ord(fread($fp,1));
			$tmp2 	= ord(fread($fp,1));
			$info["mpeg_id3v2_tag"]["version"] = "ID3v2.".$tmp.".".$tmp2;
			$tmp 	= ord(fread($fp,1));
			if($tmp & 128)$info["mpeg_id3v2_tag"]["flag"]["unsync"] = "set";
			if($tmp & 64) $info["mpeg_id3v2_tag"]["flag"]["extended"] = "set";
			if($tmp & 32) $info["mpeg_id3v2_tag"]["flag"]["experimental"] = "set";
			if($tmp & 16)
			{
				$info["mpeg_id3v2_tag"]["flag"]["footer"] = "set";
				$footer = 10;
			}
			$tmp 	= ord(fread($fp,1))& 127;
			$tmp2 	= ord(fread($fp,1))& 127;
			$tmp3	= ord(fread($fp,1))& 127;
			$tmp4 	= ord(fread($fp,1))& 127;
			$info["mpeg_id3v2_tag"]["header_lenght"] = ($tmp * 2097152) + ($tmp2 * 16384) + ($tmp3 * 128) + $tmp4 + 10 + $footer;
			fseek ($fp,$info["mpeg_id3v2_tag"]["header_lenght"]);
			$header = $info["mpeg_id3v2_tag"]["header_lenght"];
		} else {
			fseek ($fp,0);
			$info["mpeg_id3v2_tag"] = false;
		}

		for ($x=0;$x<4;$x++)
		{
			$byte[$x] = ord(fread($fp,1));
		}
		fseek ($fp, -128 ,SEEK_END);
		$TAG = fread($fp,128);
		fclose($fp);

	//id tag?-------------------------------

		if(substr($TAG,0,3) == "TAG")
		{
			$v1tag = 128;
			$info["mpeg_id3v1_tag"]["title"] 	= substr($TAG,3,40);
			$info["mpeg_id3v1_tag"]["artist"] 	= substr($TAG,33,30);
			$info["mpeg_id3v1_tag"]["album"] 	= substr($TAG,63,30);
			$info["mpeg_id3v1_tag"]["year"] 	= substr($TAG,93,4);
			$info["mpeg_id3v1_tag"]["comment"] 	= substr($TAG,97,30);
			$info["mpeg_id3v1_tag"]["genre"]	= "";
			$tmp = ord(substr($TAG,127,1));
			if($tmp < count($genre))
			{
				$info["mpeg_id3v1_tag"]["genre"] = $genre[$tmp];
			}
		} else {
			$info["mpeg_id3v1_tag"] = false;
		}

	//version-------------------------------

		$tmp = $byte[1] & 24;
		$tmp = $tmp >> 3;
		$info_i["mpeg_version"] = $tmp;
		$byte_v = $version_bitrate[$tmp];
		$byte_vs = $version_sampling[$tmp];
		$info["mpeg_version"] = $version[$tmp];

	//layer---------------------------------

		$tmp = $byte[1] & 6;
		$tmp = $tmp >> 1;
		$info_i["mpeg_layer"] = $tmp;
		$byte_l = $layer_bitrate[$tmp];
		$byte_len = $layer_lengt[$tmp];
		$info["mpeg_layer"] = $layer[$tmp];

	//bitrate-------------------------------

		$tmp = $byte[2] & 240;
		$tmp = $tmp >> 4;
		$info_i["mpeg_bitrate"] = $tmp;
		$info["mpeg_bitrate"] = $byterate[$byte_v][$byte_l][$tmp]." Кбит/сек.";

	//samplingrate--------------------------

		$tmp = $byte[2] & 12;
		$tmp = $tmp >> 2;
		$info["mpeg_sampling_rate"] = $samplingrate[$byte_vs][$tmp];

	//protection----------------------------

		$tmp = $byte[1] & 1;
		$info["mpeg_protection"] = $protection[$tmp];

	//paddingbit----------------------------

		$tmp = $byte[2] & 2;
		$tmp = $tmp >> 1;
		$byte_pad = $tmp;
		$info["mpeg_padding_bit"] = $tmp;

	//privatebit----------------------------

		$tmp = $byte[2] & 1;
		$byte_prv = $tmp;

	//channel_mode--------------------------

		$tmp = $byte[3] & 192;
		$tmp = $tmp >> 6;
		$info["mpeg_channel_mode"] = $cannel_mode[$tmp];

	//copyright-----------------------------

		$tmp = $byte[3] & 8;
		$tmp = $tmp >> 3;
		$info["mpeg_copyright"] = $copyright[$tmp];

	//original------------------------------

		$tmp = $byte[3] & 4;
		$tmp = $tmp >> 2;
		$info["mpeg_original"] = $original[$tmp];

	//emphasis------------------------------

		$tmp = $byte[3] & 3;
		$info["mpeg_emphasis"] = $emphasis[$tmp];

	//framelenght---------------------------

		if($byte_len == 0)
		{
			$rate_tmp = $info["mpeg_bitrate"] * 1000;
			$info["mpeg_framelenght"] = (12 * $rate_tmp / $info["mpeg_sampling_rate"] + $byte_pad) * 4 ;
		} elseif($byte_len == 1) {
			$rate_tmp = $info["mpeg_bitrate"] * 1000;
			$info["mpeg_framelenght"] = 144 * $rate_tmp /
			$info["mpeg_sampling_rate"] + $byte_pad;
		}

	//duration------------------------------

		$tmp = filesize($this->wave_filename);
		$tmp = $tmp - $header - 4 - $v1tag;

		$tmp2 = 0;
		if ($info["mpeg_bitrate"]<>0)
		{
			$tmp2 = ((8 * $tmp) / 1000) / $info["mpeg_bitrate"];
		}
		$info["mpeg_frames"]="";
		if ($info["mpeg_framelenght"]<>0)
		{
			$info["mpeg_frames"] = floor($tmp/$info["mpeg_framelenght"]);
		}
		$tmp = $tmp * 8;
		$info["mpeg_playtime"]="";
		if ($rate_tmp<>0)
		{
			$info["mpeg_playtime"] = $tmp/$rate_tmp;
		}
		$info["mpeg_playtime"] = $tmp2;

		// transfer the extracted data into classAudioFile-structure

		$this->wave_id = "MPEG";
		$this->wave_type = $info["mpeg_version"];
		$this->wave_compression = $info["mpeg_layer"];
		$this->wave_channels = $info["mpeg_channel_mode"];
		$this->wave_framerate = $info["mpeg_sampling_rate"];
		$this->wave_byterate = $info["mpeg_bitrate"];
		$this->wave_bits = "n/a";
		$this->wave_size = filesize($this->wave_filename);
		$this->wave_length = $info["mpeg_playtime"];

		$this->id3_tag = $info["mpeg_id3v1_tag"];

		if ($this->id3_tag)
		{
			$this->id3_title = $info["mpeg_id3v1_tag"]["title"];
			$this->id3_artist = $info["mpeg_id3v1_tag"]["artist"];
			$this->id3_album = $info["mpeg_id3v1_tag"]["album"];
			$this->id3_year = $info["mpeg_id3v1_tag"]["year"];
			$this->id3_comment = $info["mpeg_id3v1_tag"]["comment"];
			$this->id3_genre = $info["mpeg_id3v1_tag"]["genre"];
		}
	}

	// 
function getSampleInfo ()
	{
		$valid = true;

		if (strstr(strtoupper($this->wave_filename),"MP3"))
		{
			$this->mp3info ();
		} else {

			$this->wave_size = filesize ($this->wave_filename);
			if ($this->wave_size > 16)
			{
				$file = fopen ($this->wave_filename,"r");
				$chunk_id = fgetc($file) . fgetc($file) . fgetc($file) . fgetc($file);
				$null = fgetc($file) . fgetc($file) . fgetc($file) . fgetc($file);
				$chunk_id_2 = fgetc($file) . fgetc($file) . fgetc($file) . fgetc($file);
				$this->wave_id = $chunk_id;
				$this->wave_type = $chunk_id_2;
				if (substr($chunk_id,0,2)=="PK")
				{
					// it's a ZIP-file

					$this->wave_id = "ZIP";
					$this->wave_type = "ZIP";
					$this->valid = true;
				} else {
					if ($this->wave_id == "RIFF" && $this->wave_type == "WAVE")
					{
						// it's a Wave-File

						$chunk_id = fgetc($file) . fgetc($file) . fgetc($file) . fgetc($file);
						$chunk_size = $this->longCalc (fgetc($file) , fgetc($file) , fgetc($file) , fgetc($file),0);
						if ($chunk_id == "fmt ")
						{
							$format_len = $chunk_size;
							$this->wave_compression = $this->shortCalc (fgetc ($file), fgetc ($file),0);
							$this->wave_channels = $this->shortCalc (fgetc ($file), fgetc ($file),0);
							$this->wave_framerate = $this->longCalc (fgetc ($file), fgetc ($file), fgetc ($file), fgetc ($file),0);
							$this->wave_byterate = $this->longCalc (fgetc ($file), fgetc ($file), fgetc ($file), fgetc ($file),0);
							$null = fgetc($file) . fgetc($file);
							$this->wave_bits = $this->shortCalc (fgetc ($file), fgetc ($file),0);
							$read = 16;
							if ($read < $format_len)
							{
								$extra_bytes = $this->shortCalc (fgetc ($file), fgetc ($file),1);
								$j = 0;
								while ($j < $extra_bytes && !feof($file))
								{
									$null = fgetc ($file);
									$j++;
								}
							}
							$chunk_id = fgetc($file) . fgetc($file) . fgetc($file) . fgetc($file);
							$chunk_size = $this->longCalc (fgetc($file) , fgetc($file) , fgetc($file) , fgetc($file),0);
							if ($chunk_id == "data")
							{
								$this->wave_length = (($chunk_size / $this->wave_channels) / ($this->wave_bits/8)) / $this->wave_framerate;
							} else {
								while ($chunk_id <> "data" && !feof($file))
								{
									$j = 1;
									while ($j <= $chunk_size && !feof($file))
									{
										$null = fgetc ($file);
										$j++;
									}
									$chunk_id = fgetc($file) . fgetc($file) . fgetc($file) . fgetc($file);
									//print "<br>$chunk_id*";
									$chunk_size = $this->longCalc (fgetc($file) , fgetc($file) , fgetc($file) , fgetc($file),0);
								}
								if ($chunk_id == "data")
								{
									$this->wave_length = (($chunk_size / $this->wave_channels) / ($this->wave_bits/8)) / $this->wave_framerate;
								}

							}
						} else {
							$valid = false;
						}
					} else {
						if ($this->wave_id == "FORM" && $this->wave_type == "AIFF")
						{
							// we have a AIFF file here

							$chunk_id = fgetc($file) . fgetc($file) . fgetc($file) . fgetc($file);
							$chunk_size = $this->longCalc (fgetc($file) , fgetc($file) , fgetc($file) , fgetc($file),0);
							if ($chunk_id == "COMM")
							{
								$format_len = $chunk_size;
								$this->wave_channels = $this->shortCalc (fgetc ($file), fgetc ($file),1);
								$null = $this->longCalc (fgetc ($file), fgetc ($file), fgetc ($file), fgetc ($file),1);
								$this->wave_bits = $this->shortCalc (fgetc ($file), fgetc ($file),1);
								$null = fgetc ($file) . fgetc ($file);
								$this->wave_framerate = $this->shortCalc (fgetc ($file), fgetc ($file),1);

								$read = 16;
							} else {
								$valid = false;
							}
						} else {
							// probably crap

							$valid = false;
						}
					}
				}
				fclose ($file);
			} else {
				$valid = false;
			}
			return ($valid);
		}
	}

	// 
function sizes($filesize) {
    if ($filesize < 1000000) {
        $kb = round($filesize / 1000, 3);
        $resl = $kb.' Kb';
    } else {
        $mb = round($filesize / 1000000, 3);
        $resl = $mb.' Mb';
    }
    return $resl;
}
function filter($indata) {
	$in = trim($indata);
	$in = htmlspecialchars($in);
	return $in;
}
function printSampleInfo()
{
print '<div class="main">';
function repl($text){
$repl1 = array("&", "", "", "", "");
$repl2 = array("&amp;", "", "", "", "");
return iconv('windows-1251','UTF-8', str_replace($repl1, $repl2, $text));
}
if($title = repl(trim($this->id3_title))){
print 'Nomi: '.$title.'<br/>';
}

if($artist = repl(trim($this->id3_artist))){
print 'Artist: '.$artist.'<br/>';
}


if($album = repl(trim($this->id3_album))){
print 'Albom: '.$album.'<br/>';
}


if($year = intval(trim($this->id3_year))){
print 'Yozilgan yili: '.$year.'<br/>';
}


if($genre = repl(trim($this->id3_genre))){
print 'Janr: '.$genre.'<br/>';
}


print 'Davomiyligi: '.date('i:s', mktime(0,0,round($this->wave_length))).' daqiqa<br/>
Kanallar: '.$this->wave_channels.'<br/>
Chastota: '.$this->wave_framerate.' Gts<br/>
Bitreyt: '.$this->wave_byterate.'<br/>Og`rligi: '.self::sizes($this->wave_size).'<br/>';
print '</div>';
return;
}
function loadFile ($loadFilename)
	{
		$this->wave_filename = $loadFilename;
		$this->getSampleInfo ();
		$this->visual_graph_color = "#18F3AD";
		$this->visual_background_color = "#000000";
		$this->visual_grid_color = "#002C4A";
		$this->visual_border_color = "#A52421";
		$this->visual_grid = true;
		$this->visual_border = true;
		$this->visual_width = 600;
		$this->visual_height = 512;
		$this->visual_graph_mode = 1;
		$this->visual_fileformat = "png";
	}

    function __construct($file = false)
    {
        self::$includePath = dirname(__FILE__);
        self::$root = $_SERVER['DOCUMENT_ROOT'];
    }
    
    /**
     * Фильтрация строки
    **/
    
    private function clean($string)
    {
        $string = htmlspecialchars(trim($string));
        return $string;
    }
    
    /**
     * Получаем информацию о мп3 файле
    **/
    
    public function GetMp3Info($file, $mode = false)
    {
        $file = $file;
        if(empty($file)) {
            exit('Error! Path to file is empty');
        }
        if(!file_exists($file)) {
            exit('Error! File '.$file.' not exists');
        }
        if(self::ext($file) != 'mp3') {
            exit('Error! Valid format files only mp3!');
        }
        require_once(self::$includePath.'/getid3/getid3.php');
        $ID3 = new getID3;
        $ID3->encoding = 'UTF-8';
        $analyze = $ID3->analyze($file);
        $audio = $analyze['audio'];
        $info['bitrate'] = $audio['bitrate'];
        $info['samplerate'] = $audio['sample_rate'];
        $info['cannels'] = $audio['channels'];
        $info['duration'] = ceil($analyze['playtime_seconds']);
        $info['filesize'] = $analyze['filesize'];
        if(!empty($analyze['tags']['id3v2'])) {
            $tags = $analyze['tags']['id3v2'];
        }
        elseif(!empty($analyze['tags']['id3v1'])) {
            $tags = $analyze['tags']['id3v1'];
        }
        else { 
            $tags['artist'][0] = 'Unkown artist';
            $tags['title'][0] = 'No name';
            $tags['genre'][0] = 'Other';
            $tags['year'][0] = '1970';
            $tags['comment'][0] = '';
            $tags['album'][0] = 'Unkown';
        }
        if($mode != false) {
            return $tags;
        }
        $info['artist'] = isset($tags['artist'][0]) ? self::clean($tags['artist'][0]) : false;
        $info['title'] = isset($tags['title'][0]) ? self::clean($tags['title'][0]) : false;
        $info['genre'] = isset($tags['genre'][0]) ? self::clean($tags['genre'][0]) : false;
        $info['year'] = isset($tags['year'][0]) ? self::clean($tags['year'][0]) : false;
        $info['comment'] = isset($tags['comment'][0]) ? self::clean($tags['comment'][0]) : false;
        $info['album'] = isset($tags['album'][0]) ? self::clean($tags['album'][0]) : false;
        if(isset($analyze['id3v2']['APIC'][0]['data'])) {
            $info['cover'] = $analyze['id3v2']['APIC'][0]['data'];
        }
        return $info;
        
    }
    
    /**
     * Записываем обложку
    **/
    
    public function Write($file, $tags = false, $cover = false)
    {
        $file = $file;
        if(empty($file)) {
            exit('Error! Path to file is empty');
        }
        if(!file_exists($file)) {
            exit('Error! File '.$file.' not exists');
        }
        if($cover == false || !is_array($tags) || !is_string($cover)) {
            exit('Error! There are no required parameters!');
        }
        $tagArr = self::GetMp3Info($file, true);
        if(!empty($cover)) {
            $cover = $cover;
            if(!file_exists($cover)) {
                exit('File of cover not exists!' . $cover);
            }
            if(self::ext($cover) != 'jpg' && self::ext($cover) != 'jpeg') {
                exit('Invalid mime type of cover image. Allowed mime type is jpeg!');
            }
            if(filesize($cover) > 100 * 1024) {
                exit('File size of cover image is big. Max allowed file size is 100kb!');
            }
            $data['attached_picture'][] = array(
                                               'data' => file_get_contents($cover),
                                               'description' => 'cover',
                                               'picturetypeid' => '1',
                                               'mime' => 'image/jpeg');
        }
        if(!empty($tags)) {
            if(!is_array($tags)) {
                exit('Error! Tags must be an array!');
            }
            foreach($tags as $key => $value) {
                $data[$key][0] = $value;
            }
        }
        if(!empty($tags)) {
            $tagArr = array_merge($tagArr, $data);
        }
        require_once(self::$includePath . '/getid3/write.php');
        $write = new getid3_writetags;
        $write->filename = $file;
        $write->remove_other_tags = false;
        $write->overwrite_tags = true;
        $write->tag_encoding = 'UTF-8';
        $write->tag_data = $tagArr;
        $write->tagformats = array('id3v1', 'id3v2.3');
        return $write->WriteTags();
    }
    
    /**
     * Обезаем мелодию, если передан параметр
    **/
    
    private function Cut($time = array())
    {
        if(!is_array($time)) {
            exit('Error! Time parameters must be an array!');
        }
        $start = gmdate('H:i:s', $time[0]);
        $end = gmdate('H:i:s', floor($time[1] - $time[0]));
        if($start > $end) {
            exit('Error! Start time should not be greater than the final time');
        }
        return '-ss ' . $start . ' -t ' . $end;
    }
    
    /**
     * Конвертация 
    **/
    
    public function Convert ($file, $bit, $outFile, $time = false)
    {
        if(empty($file)) {
            exit('Error! Path to file is empty');
        }
        if(!file_exists($file)) {
            exit('Error! File '.$file.' not exists');
        }
        $ext = self::ext($outFile);
        $outFile = self::$root. '/download/' . $outFile;
        $outFile = $outFile;
        $codecs = array(
                        'mp3' => 'libmp3lame',
                        'wav' => 'adpcm_ima_wav',
                        'aac' => 'libfaac',
                        'm4a' => 'libfaac',
                        'wma' => 'wmav1'
                       );
        $sampleRate = array(
                            '320' => '44100',
                            '256' => '44100',
                            '192' => '44100',
                            '160' => '44100',
                            '128' => '44100',
                            '64'  => '22050',
                            '32'  => '22050'
                           );
        $info = self::GetMp3Info($file);
        if((ceil($info['bitrate'] / 1000) < $bit) || (ceil($info['bitrate'] / 1000) == $bit && $ext == 'mp3')) {
            exit('Error! The new bitrate can not exceed the bitrate of the original file!');
        }
        if($time != false) {
            $cut = self::Cut($time);
        }
        if(file_exists($outFile)) {
            return true;
        }
        if(exec('ffmpeg -i ' . self::$root. '/download/' . $file . ' -acodec ' . $codecs[$ext] . ' -ar ' . $sampleRate[$bit] . ' -ab ' . $bit . 'K' . (isset($cut) ? ' ' . $cut : '') . ' -ac 2 ' . $outFile))
            return true;
        else
            return false;
    }
}