/*
 * Decompiled with CFR 0.152.
 */
package br;

import br.Menu;
import br.Plugin;
import br.ReadCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStore;

public class BookReader
extends MIDlet
implements CommandListener,
Runnable {
    static BookReader instance = null;
    public static Display display;
    ReadCanvas myView = null;
    List myBookList = null;
    static Menu MENU;
    Command myTextEditCommand = null;
    static final Command CMD_OK;
    static final Command CMD_CANCEL;
    static final Command CMD_OPEN;
    static final Command CMD_EXIT;
    static final Command CMD_RENAME;
    static final Command CMD_DOWNLOAD;
    static String ERROR_OUT_OF_MEM;
    public static int BACKGROUND_COLOR;
    boolean myIsFirstTime = false;
    static RecordStore myRS;
    private static String myState;
    static Plugin myPlatformPlugin;
    static String[] PLATFORM_CLASSES;
    int myJarEntryCount = 0;
    public static char[] TEXT_ENCODING;
    Form myLoadingForm = null;

    public BookReader() {
        char[] cArray;
        String string;
        instance = this;
        int n = PLATFORM_CLASSES.length;
        for (int i = 0; i < n; ++i) {
            string = PLATFORM_CLASSES[i];
            try {
                Class<?> clazz = Class.forName(string);
                myPlatformPlugin = (Plugin)Class.forName(string).newInstance();
                break;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        if ((cArray = this.readChars("/encoding.txt")) == null) {
            cArray = new char[128];
            for (n = 0; n < 128; ++n) {
                cArray[n] = (char)(n + 128);
            }
        }
        TEXT_ENCODING = cArray;
        try {
            InputStream inputStream = null;
            do {
                string = this.myJarEntryCount == 0 ? "/textfile.txt" : "/textfile" + this.myJarEntryCount + ".txt";
                inputStream = this.getClass().getResourceAsStream(string);
                if (inputStream == null) continue;
                inputStream.close();
                ++this.myJarEntryCount;
            } while (inputStream != null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public char[] readChars(String string) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            object = new DataInputStream(inputStream);
            ((DataInputStream)object).readChar();
            try {
                while (true) {
                    stringBuffer.append(((DataInputStream)object).readChar());
                }
            }
            catch (EOFException eOFException) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            return null;
        }
        int n = stringBuffer.length();
        object = new char[n];
        stringBuffer.getChars(0, n, (char[])object, 0);
        return object;
    }

    public void startApp() throws MIDletStateChangeException {
        Object object;
        display = Display.getDisplay((MIDlet)this);
        MENU = new Menu();
        myState = null;
        try {
            myRS = RecordStore.openRecordStore((String)"strprops", (boolean)true);
            if (myRS.getNextRecordID() != 1 && (object = myRS.getRecord(1)) != null) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                myState = dataInputStream.readUTF();
            }
        }
        catch (Exception exception) {
            myRS = null;
            myState = null;
        }
        if (myState == null) {
            myState = "\n";
            object = this.readChars("/props.ini");
            if (object != null) {
                myState = myState + new String((char[])object);
            }
        }
        ReadCanvas.INC_HEIGHT = BookReader.getIntProperty("main", "plusheight", 0);
        ReadCanvas.BGCOLOR = BookReader.getIntProperty("main", "bgcolor", 0xFFFFFF);
        ReadCanvas.FGCOLOR = BookReader.getIntProperty("main", "fgcolor", 0);
        ReadCanvas.HAS_DIR_BUTTONS = "true".equals(BookReader.getProperty("main", "hasdirbuttons"));
        BookReader.setBackLight(true);
        this.myView = new ReadCanvas(display);
        this.myBookList = new List("Books", 3);
        this.myBookList.addCommand(CMD_OPEN);
        this.myBookList.addCommand(CMD_EXIT);
        this.myBookList.addCommand(CMD_RENAME);
        this.myBookList.addCommand(CMD_DOWNLOAD);
        this.myBookList.setCommandListener((CommandListener)this);
        object = BookReader.getProperty("main", "lasttext");
        this.myIsFirstTime = true;
        int n = this.myJarEntryCount;
        for (int i = 0; i < n; ++i) {
            String string = this.getBookId(i);
            String string2 = BookReader.getProperty(string, "label");
            if (string2 == null) {
                string2 = "Jar Book " + (i + 1);
            }
            this.myBookList.append(string2, null);
            if (!string.equals(object)) continue;
            this.myBookList.setSelectedIndex(i, true);
            this.myIsFirstTime = false;
        }
        display.setCurrent((Displayable)this.myBookList);
        if (!this.myIsFirstTime) {
            this.waitLoadSelectedText();
        }
    }

    private String getBookId(int n) {
        return n == 0 ? "J/textfile.txt" : "J/textfile" + n + ".txt";
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == List.SELECT_COMMAND || command == CMD_OPEN) {
            this.waitLoadSelectedText();
        } else if (command == CMD_RENAME) {
            this.renameBook(null);
        } else if (command == CMD_OK && displayable == this.myLoadingForm) {
            display.setCurrent((Displayable)this.myView);
        } else if (command == CMD_OK && this.myTextEditCommand == CMD_RENAME && displayable instanceof TextBox) {
            this.renameBook((TextBox)displayable);
        } else if (command == CMD_CANCEL) {
            display.setCurrent((Displayable)this.myBookList);
        } else if (command == CMD_EXIT) {
            if (displayable != this.myBookList) {
                display.setCurrent((Displayable)this.myBookList);
            } else {
                this.destroyApp(true);
            }
        }
    }

    public static void setProperty(String string, String string2, String string3) {
        String string4 = "\n" + string + "." + string2 + "=";
        int n = myState.indexOf(string4);
        if (n == -1) {
            myState = myState + string4 + string3;
        } else {
            int n2 = myState.indexOf("\n", n += string4.length());
            if (n2 == -1) {
                n2 = myState.length();
            }
            myState = myState.substring(0, n) + string3 + myState.substring(n2);
        }
    }

    public static int getIntProperty(String string, String string2, int n) {
        String string3 = BookReader.getProperty(string, string2);
        if (string3 != null) {
            n = Integer.parseInt(string3);
        }
        return n;
    }

    public static String getProperty(String string, String string2) {
        String string3 = "\n" + string + "." + string2 + "=";
        String string4 = null;
        int n = myState.indexOf(string3);
        if (n != -1) {
            int n2 = myState.indexOf("\n", n += string3.length());
            if (n2 == -1) {
                n2 = myState.length();
            }
            if (myState.charAt(n2 - 1) == '\r') {
                --n2;
            }
            string4 = myState.substring(n, n2);
        }
        return string4;
    }

    public static void saveProps(boolean bl) {
        try {
            if (myRS != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeUTF(myState.toString());
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (myRS.getNextRecordID() == 1) {
                    myRS.addRecord(byArray, 0, byArray.length);
                } else {
                    myRS.setRecord(1, byArray, 0, byArray.length);
                }
                if (bl) {
                    myRS.closeRecordStore();
                    myRS = null;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("error saving/closing props:" + exception);
        }
    }

    public void run() {
        String string = null;
        try {
            this.myView.setText(null, null);
            String string2 = this.getBookId(this.myBookList.getSelectedIndex());
            this.myView.setText(string2, BookReader.getProperty(string2, "label"));
            this.myLoadingForm.addCommand(CMD_OK);
            ((StringItem)this.myLoadingForm.get(0)).setText("");
            if (!this.myIsFirstTime) {
                display.setCurrent((Displayable)this.myView);
            }
            this.myIsFirstTime = false;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            string = ERROR_OUT_OF_MEM;
        }
        catch (Throwable throwable) {
            string = "cant read text:" + throwable.getMessage();
        }
        if (string != null) {
            this.myView.showMessage("Error", string, AlertType.ERROR, null);
        }
    }

    void waitLoadSelectedText() {
        String string = "Loading...";
        if (this.myLoadingForm == null) {
            this.myLoadingForm = new Form("(c)tequilaCat");
            this.myLoadingForm.append(string);
            this.myLoadingForm.append(this.myView.HELP_MESSAGE);
            this.myLoadingForm.setCommandListener((CommandListener)this);
        } else {
            ((StringItem)this.myLoadingForm.get(0)).setText(string);
            this.myLoadingForm.removeCommand(CMD_OK);
        }
        display.setCurrent((Displayable)this.myLoadingForm);
        String string2 = this.getBookId(this.myBookList.getSelectedIndex());
        if (!string2.equals(BookReader.getProperty("main", "lasttext"))) {
            BookReader.setProperty("main", "lasttext", string2);
            BookReader.saveProps(false);
        }
        new Thread(this).start();
    }

    public void pauseApp() {
        BookReader.setBackLight(false);
        BookReader.saveProps(true);
        display = null;
        this.myView = null;
        MENU = null;
    }

    public static void setBackLight(boolean bl) {
        if (myPlatformPlugin != null) {
            myPlatformPlugin.backlight(bl);
        }
    }

    public void destroyApp(boolean bl) {
        BookReader.saveProps(true);
        this.notifyDestroyed();
    }

    public void showBooksList() {
        this.myView.setText(null, null);
        BookReader.setProperty("main", "lasttext", "");
        BookReader.saveProps(false);
        display.setCurrent((Displayable)this.myBookList);
    }

    private void renameBook(TextBox textBox) {
        String string = this.getBookId(this.myBookList.getSelectedIndex());
        if (textBox == null) {
            this.myTextEditCommand = CMD_RENAME;
            String string2 = BookReader.getProperty(string, "label");
            if (string2 == null) {
                string2 = this.myBookList.getString(this.myBookList.getSelectedIndex());
            }
            this.myView.input("Rename", string2, 0, this);
        } else {
            String string3 = textBox.getString();
            BookReader.setProperty(string, "label", string3);
            BookReader.saveProps(false);
            this.myBookList.set(this.myBookList.getSelectedIndex(), string3, null);
            display.setCurrent((Displayable)this.myBookList);
        }
    }

    static {
        CMD_OK = new Command("Ok", 4, 0);
        CMD_CANCEL = new Command("Cancel", 3, 0);
        CMD_OPEN = new Command("Open", 4, 0);
        CMD_EXIT = new Command("Exit", 6, 0);
        CMD_RENAME = new Command("Rename", 8, 1);
        CMD_DOWNLOAD = new Command("Download", 8, 1);
        ERROR_OUT_OF_MEM = "Sorry, text is too big. Try splitting it onto smaller parts.\nTEKCT HE B/\\E3, nuXAuTE KyCKAMu.";
        BACKGROUND_COLOR = 0xFFFFFF;
        myRS = null;
        myState = null;
        myPlatformPlugin = null;
        PLATFORM_CLASSES = new String[]{"platform.Nokia", "platform.Siemens", "platform.MotorolaTaiChiLite", "platform.MotorolaC450", "platform.SE_T610"};
        TEXT_ENCODING = null;
    }
}

