--
-- Структура таблицы `cms_ads`
--
DROP TABLE IF EXISTS `cms_ads`;
CREATE TABLE IF NOT EXISTS `cms_ads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `view` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `layout` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `count_link` int(10) unsigned NOT NULL DEFAULT '0',
  `name` text NOT NULL,
  `link` text NOT NULL,
  `to` int(10) unsigned NOT NULL DEFAULT '0',
  `color` varchar(10) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `day` int(10) unsigned NOT NULL DEFAULT '0',
  `mesto` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `bold` tinyint(1) NOT NULL DEFAULT '0',
  `italic` tinyint(1) NOT NULL DEFAULT '0',
  `underline` tinyint(1) NOT NULL DEFAULT '0',
  `show` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;
  
INSERT INTO `cms_ads` (`id`, `type`, `view`, `layout`, `count`, `count_link`, `name`, `link`, `to`, `color`, `time`, `day`, `mesto`, `bold`, `italic`, `underline`, `show`) VALUES
(1, 1, 0, 0, 0, 0, 'UzDown.Ru - Cheksiz yuklamalar', 'http://uzdown.ru', 0, '', 1443110994, 0, 1, 1, 0, 0, 1);
--
-- Структура таблицы `cms_album_cat`
--
DROP TABLE IF EXISTS `cms_album_cat`;
CREATE TABLE `cms_album_cat` (
  `id`          INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `user_id`     INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `sort`        INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `name`        VARCHAR(40)         NOT NULL DEFAULT '',
  `description` TEXT                NOT NULL,
  `password`    VARCHAR(20)         NOT NULL DEFAULT '',
  `access`      TINYINT(4) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `access` (`access`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_album_comments`
--
DROP TABLE IF EXISTS `cms_album_comments`;
CREATE TABLE `cms_album_comments` (
  `id`         INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `sub_id`     INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `time`       INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id`    INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `text`       TEXT             NOT NULL,
  `reply`      TEXT             NOT NULL,
  `attributes` TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_album_downloads`
--
DROP TABLE IF EXISTS `cms_album_downloads`;
CREATE TABLE `cms_album_downloads` (
  `user_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `file_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `time`    INT(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`, `file_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_album_files`
--
DROP TABLE IF EXISTS `cms_album_files`;
CREATE TABLE `cms_album_files` (
  `id`              INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `user_id`         INT(10) UNSIGNED    NOT NULL,
  `album_id`        INT(10) UNSIGNED    NOT NULL,
  `description`     TEXT                NOT NULL,
  `img_name`        VARCHAR(100)        NOT NULL DEFAULT '',
  `tmb_name`        VARCHAR(100)        NOT NULL DEFAULT '',
  `time`            INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `comments`        TINYINT(1)          NOT NULL DEFAULT '1',
  `comm_count`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `access`          TINYINT(4) UNSIGNED NOT NULL DEFAULT '0',
  `vote_plus`       INT(11)             NOT NULL DEFAULT '0',
  `vote_minus`      INT(11)             NOT NULL DEFAULT '0',
  `views`           INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `downloads`       INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `unread_comments` TINYINT(1)          NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `album_id` (`album_id`),
  KEY `access` (`access`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_album_views`
--
DROP TABLE IF EXISTS `cms_album_views`;
CREATE TABLE `cms_album_views` (
  `user_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `file_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `time`    INT(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`, `file_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_album_votes`
--
DROP TABLE IF EXISTS `cms_album_votes`;
CREATE TABLE `cms_album_votes` (
  `id`      INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `file_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `vote`    TINYINT(2)       NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `file_id` (`file_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_ban_ip`
--
DROP TABLE IF EXISTS `cms_ban_ip`;
CREATE TABLE `cms_ban_ip` (
  `id`       INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ip1`      BIGINT(11)       NOT NULL DEFAULT '0',
  `ip2`      BIGINT(11)       NOT NULL DEFAULT '0',
  `ban_type` TINYINT(4)       NOT NULL DEFAULT '0',
  `link`     VARCHAR(100)     NOT NULL,
  `who`      VARCHAR(25)      NOT NULL,
  `reason`   TEXT             NOT NULL,
  `date`     INT(11)          NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip1` (`ip1`),
  UNIQUE KEY `ip2` (`ip2`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_ban_users`
--
DROP TABLE IF EXISTS `cms_ban_users`;
CREATE TABLE `cms_ban_users` (
  `id`         INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id`    INT(11)          NOT NULL DEFAULT '0',
  `ban_time`   INT(11)          NOT NULL DEFAULT '0',
  `ban_while`  INT(11)          NOT NULL DEFAULT '0',
  `ban_type`   TINYINT(4)       NOT NULL DEFAULT '1',
  `ban_who`    VARCHAR(30)      NOT NULL DEFAULT '',
  `ban_ref`    INT(11)          NOT NULL DEFAULT '0',
  `ban_reason` TEXT             NOT NULL,
  `ban_raz`    VARCHAR(30)      NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `ban_time` (`ban_time`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_contact`
--
DROP TABLE IF EXISTS `cms_contact`;
CREATE TABLE IF NOT EXISTS `cms_contact` (
  `id`      INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `user_id` INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `from_id` INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `time`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `type`    TINYINT(1) UNSIGNED NOT NULL DEFAULT '1',
  `friends` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `ban`     TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `man`     TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_user` (`user_id`, `from_id`),
  KEY `time` (`time`),
  KEY `ban` (`ban`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_counters`
--
DROP TABLE IF EXISTS `cms_counters`;
CREATE TABLE `cms_counters` (
  `id`     INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `sort`   INT(10)          NOT NULL DEFAULT '1',
  `name`   VARCHAR(30)      NOT NULL,
  `link1`  TEXT             NOT NULL,
  `link2`  TEXT             NOT NULL,
  `mode`   TINYINT(4)       NOT NULL DEFAULT '1',
  `switch` TINYINT(1)       NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_forum_files`
--
DROP TABLE IF EXISTS `cms_forum_files`;
CREATE TABLE `cms_forum_files` (
  `id`       INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `cat`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `subcat`   INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `topic`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `post`     INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `time`     INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `filename` TEXT                NOT NULL,
  `filetype` TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  `dlcount`  INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `del`      TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cat` (`cat`),
  KEY `subcat` (`subcat`),
  KEY `topic` (`topic`),
  KEY `post` (`post`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_forum_rdm`
--
DROP TABLE IF EXISTS `cms_forum_rdm`;
CREATE TABLE `cms_forum_rdm` (
  `topic_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id`  INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `time`     INT(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`topic_id`, `user_id`),
  KEY `time` (`time`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_forum_vote`
--
DROP TABLE IF EXISTS `cms_forum_vote`;
CREATE TABLE `cms_forum_vote` (
  `id`    INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type`  INT(2)           NOT NULL DEFAULT '0',
  `time`  INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `topic` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `name`  VARCHAR(200)     NOT NULL,
  `count` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `topic` (`topic`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_forum_vote_users`
--
DROP TABLE IF EXISTS `cms_forum_vote_users`;
CREATE TABLE `cms_forum_vote_users` (
  `id`    INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user`  INT(11)          NOT NULL DEFAULT '0',
  `topic` INT(11)          NOT NULL,
  `vote`  INT(11)          NOT NULL,
  PRIMARY KEY (`id`),
  KEY `topic` (`topic`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_mail`
--
DROP TABLE IF EXISTS `cms_mail`;
CREATE TABLE IF NOT EXISTS `cms_mail` (
  `id`        INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `user_id`   INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `from_id`   INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `text`      TEXT                NOT NULL,
  `time`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `read`      TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `sys`       TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `delete`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `file_name` VARCHAR(100)        NOT NULL DEFAULT '',
  `count`     INT(10)             NOT NULL DEFAULT '0',
  `size`      INT(10)             NOT NULL DEFAULT '0',
  `them`      VARCHAR(100)        NOT NULL DEFAULT '',
  `spam`      TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `from_id` (`from_id`),
  KEY `time` (`time`),
  KEY `read` (`read`),
  KEY `sys` (`sys`),
  KEY `delete` (`delete`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_sessions`
--
DROP TABLE IF EXISTS `cms_sessions`;
CREATE TABLE `cms_sessions` (
  `session_id`   CHAR(32)             NOT NULL DEFAULT '',
  `ip`           BIGINT(11)           NOT NULL DEFAULT '0',
  `ip_via_proxy` BIGINT(11)           NOT NULL DEFAULT '0',
  `browser`      VARCHAR(255)         NOT NULL DEFAULT '',
  `lastdate`     INT(10) UNSIGNED     NOT NULL DEFAULT '0',
  `sestime`      INT(10) UNSIGNED     NOT NULL DEFAULT '0',
  `views`        INT(10) UNSIGNED     NOT NULL DEFAULT '0',
  `movings`      SMALLINT(5) UNSIGNED NOT NULL DEFAULT '0',
  `place`        VARCHAR(100)         NOT NULL DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `lastdate` (`lastdate`),
  KEY `place` (`place`(10))
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_settings`
--
DROP TABLE IF EXISTS `cms_settings`;
CREATE TABLE `cms_settings` (
  `key` TINYTEXT NOT NULL,
  `val` TEXT     NOT NULL,
  PRIMARY KEY (`key`(30))
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

INSERT INTO `cms_settings` (`key`, `val`) VALUES
('active', '1'),
('admp', 'panel'),
('antiflood', 'a:5:{s:4:"mode";i:2;s:3:"day";i:10;s:5:"night";i:30;s:7:"dayfrom";i:10;s:5:"dayto";i:22;}'),
('clean_time', '1443091013'),
('copyright', 'JohnCMS mod by M-Files001'),
('email', 'mr.mirshoxid@mail.ru'),
('flsz', '4000'),
('gzip', '1'),
('homeurl', 'http://test3.ru'),
('karma', 'a:6:{s:12:"karma_points";i:5;s:10:"karma_time";i:86400;s:5:"forum";i:20;s:4:"time";i:0;s:2:"on";i:1;s:3:"adm";i:0;}'),
('lng', 'uz'),
('mod_reg', '2'),
('mod_forum', '2'),
('mod_guest', '2'),
('mod_lib', '2'),
('mod_gal', '2'),
('mod_down_comm', '1'),
('mod_down', '2'),
('mod_lib_comm', '1'),
('mod_gal_comm', '1'),
('meta_desc', 'JohnCMS mod by M-Files001, http://webdars.uz, http://uzdown.ru'),
('meta_key', 'johncms, M-Files001,'),
('news', 'a:8:{s:4:"view";i:1;s:4:"size";i:200;s:8:"quantity";i:5;s:4:"days";i:3;s:6:"breaks";b:1;s:7:"smileys";b:1;s:4:"tags";b:1;s:3:"kom";b:1;}'),
('reg_message', ''),
('setting_mail', ''),
('skindef', 'okfan'),
('them_message', ''),
('timeshift', '0'),
('site_access', '2'),
('lng_list', 'a:1:{s:1:"O''zbekcha";}');

--
-- Структура таблицы `cms_users_data`
--
DROP TABLE IF EXISTS `cms_users_data`;
CREATE TABLE `cms_users_data` (
  `id`      INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `key`     VARCHAR(30)      NOT NULL DEFAULT '',
  `val`     TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `key` (`key`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_users_guestbook`
--
DROP TABLE IF EXISTS `cms_users_guestbook`;
CREATE TABLE `cms_users_guestbook` (
  `id`         INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `sub_id`     INT(10) UNSIGNED NOT NULL,
  `time`       INT(11)          NOT NULL,
  `user_id`    INT(10) UNSIGNED NOT NULL,
  `text`       TEXT             NOT NULL,
  `reply`      TEXT             NOT NULL,
  `attributes` TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_users_iphistory`
--
DROP TABLE IF EXISTS `cms_users_iphistory`;
CREATE TABLE `cms_users_iphistory` (
  `id`           BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id`      INT(10) UNSIGNED    NOT NULL,
  `ip`           BIGINT(11)          NOT NULL DEFAULT '0',
  `ip_via_proxy` BIGINT(11)          NOT NULL DEFAULT '0',
  `time`         INT(10) UNSIGNED    NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `user_ip` (`ip`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `download`
--
DROP TABLE IF EXISTS `download`;
CREATE TABLE `download` (
  `id`     INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `refid`  INT(11)          NOT NULL DEFAULT '0',
  `adres`  TEXT             NOT NULL,
  `time`   INT(11)          NOT NULL DEFAULT '0',
  `name`   TEXT             NOT NULL,
  `type`   VARCHAR(4)       NOT NULL DEFAULT '',
  `avtor`  VARCHAR(25)      NOT NULL DEFAULT '',
  `ip`     TEXT             NOT NULL,
  `soft`   TEXT             NOT NULL,
  `text`   TEXT             NOT NULL,
  `screen` TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `refid` (`refid`),
  KEY `time` (`time`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `forum`
--
DROP TABLE IF EXISTS `forum`;
CREATE TABLE `forum` (
  `id`           INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `refid`        INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `type`         CHAR(1)          NOT NULL DEFAULT '',
  `time`         INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id`      INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `from`         VARCHAR(25)      NOT NULL DEFAULT '',
  `realid`       INT(3)           NOT NULL DEFAULT '0',
  `ip`           BIGINT(11)       NOT NULL DEFAULT '0',
  `ip_via_proxy` BIGINT(11)       NOT NULL DEFAULT '0',
  `soft`         TEXT             NOT NULL,
  `text`         TEXT             NOT NULL,
  `close`        TINYINT(1)       NOT NULL DEFAULT '0',
  `close_who`    VARCHAR(25)      NOT NULL DEFAULT '',
  `vip`          TINYINT(1)       NOT NULL DEFAULT '0',
  `edit`         TEXT             NOT NULL,
  `tedit`        INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `kedit`        INT(2) UNSIGNED  NOT NULL DEFAULT '0',
  `curators`     TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `type` (`type`),
  KEY `time` (`time`),
  KEY `close` (`close`),
  KEY `user_id` (`user_id`),
  FULLTEXT KEY `text` (`text`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `gallery`
--
DROP TABLE IF EXISTS `gallery`;
CREATE TABLE `gallery` (
  `id`    INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `refid` INT(11)          NOT NULL DEFAULT '0',
  `time`  INT(11)          NOT NULL DEFAULT '0',
  `type`  VARCHAR(2)       NOT NULL DEFAULT '',
  `avtor` VARCHAR(25)      NOT NULL DEFAULT '',
  `text`  TEXT             NOT NULL,
  `name`  TEXT             NOT NULL,
  `user`  BINARY(1)        NOT NULL DEFAULT '\0',
  `ip`    TEXT             NOT NULL,
  `soft`  TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `type` (`type`),
  KEY `time` (`time`),
  KEY `avtor` (`avtor`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `guest`
--
DROP TABLE IF EXISTS `guest`;
CREATE TABLE `guest` (
  `id`         INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `adm`        TINYINT(1)          NOT NULL DEFAULT '0',
  `time`       INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `user_id`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `name`       VARCHAR(25)         NOT NULL DEFAULT '',
  `text`       TEXT                NOT NULL,
  `ip`         BIGINT(11)          NOT NULL DEFAULT '0',
  `browser`    TINYTEXT            NOT NULL,
  `admin`      VARCHAR(25)         NOT NULL DEFAULT '',
  `otvet`      TEXT                NOT NULL,
  `otime`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `edit_who`   VARCHAR(20)         NOT NULL DEFAULT '',
  `edit_time`  INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `edit_count` TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `ip` (`ip`),
  KEY `adm` (`adm`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `karma_users`
--
DROP TABLE IF EXISTS `karma_users`;
CREATE TABLE `karma_users` (
  `id`         INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `user_id`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `name`       VARCHAR(50)         NOT NULL DEFAULT '',
  `karma_user` INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `points`     TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  `type`       TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  `time`       INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `text`       TEXT                NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `karma_user` (`karma_user`),
  KEY `type` (`type`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `library_cats`
--
DROP TABLE IF EXISTS `library_cats`;
CREATE TABLE IF NOT EXISTS `library_cats` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(200) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `dir` tinyint(1) NOT NULL DEFAULT '0',
  `pos` int(10) unsigned NOT NULL DEFAULT '0',
  `user_add` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;
INSERT INTO `library_cats` (`id`, `parent`, `name`, `description`, `dir`, `pos`, `user_add`) VALUES
(1, 0, 'Odnoklassniki sirlari', '', 0, 1, 0);
--
-- Структура таблицы `library_texts`
--
DROP TABLE IF EXISTS `library_texts`;
CREATE TABLE IF NOT EXISTS `library_texts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0',
  `text` mediumtext NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `announce` text,
  `uploader` varchar(100) NOT NULL DEFAULT '',
  `uploader_id` int(10) unsigned NOT NULL DEFAULT '0',
  `count_views` int(10) unsigned NOT NULL DEFAULT '0',
  `premod` tinyint(1) NOT NULL DEFAULT '0',
  `comments` tinyint(1) NOT NULL DEFAULT '0',
  `count_comments` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  FULLTEXT KEY `text` (`text`,`name`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;
INSERT INTO `library_texts` (`id`, `cat_id`, `text`, `name`, `announce`, `uploader`, `uploader_id`, `count_views`, `premod`, `comments`, `count_comments`, `time`) VALUES
(1, 1, 'Xatcho''p bu\r\nOdnoklassniki.ru saytidan\r\nfoydalanishda sizu-bizga\r\nyaratilgan qulayliklardan\r\nbiri bo''lib bu bilan biz\r\nodnoklassniki.ru saytida "Tez qulay, oson, samarali va shu bilan birga ozmuncha Trafikni tejash imkoniyatiga ega bo''lamiz. Xo''p Xatcho''p ning qulayliklari xaqida\r\ngaplashib oldik endi esa uni qanday maqsadlarda foydalanish to''g''risida\r\ngaplashamiz. Demak,\r\nboshladik. Odnoklassniki.ru saytida biror bir do''stimiz bizga\r\nkerak uni oson Yoki biror bir guruh yoki undagi biror mavzu siz uchun muhim va uni tezda\r\nTopishni xoxlaymiz. Bunda bizga Xatcho''p\r\nyordam beradi. Bizga kerak bo''lgan do''stimiz yoki biror guruh yoki kerak bo''lgan guruhdagi biror mavzuni Xatcho''p ga kiritishni istasak buning uchun Xatcho''p belgisi\r\nya''ni "kichik yulduzcha" ga bosamiz sahifa\r\nyangilanadi va "qo''shish"\r\ntugmasini bosamiz va tayyor. Endi esa qo''shilgan Xatcho''p ni\r\nqayerdan topamiz degan\r\nsavol tug''iladi. Hech\r\no''ylanmang bu juda\r\noddiy. Buning bosh\r\nsahifaga o''tamiz va u yerdan "Boshqa bo''limlar"ga bosamiz\r\nyangi oyna ochiladi u yerdan Xatcho''p yozuvni topib ustiga bosamiz. Xatcho''p ga kiritgan Guruh, mavzu, do''stimiz va hokazolar turadi va\r\nqaysi biri kerak bo''lsa\r\nmasalan guruhdagi biror\r\nmavzuni kiritgan bo''lsangiz o''sha\r\nXatcho''p ustiga bosamiz va to''g''ridan to''g''ri o''sha\r\nmavzuga o''tamiz.\r\nShunday qilib biz\r\nXatcho''p yordamida\r\nfoydalanish tog''risi bilib oldik. Savollar bo''lsa Mehmonxonada\r\nkutamiz. Hammaga omad.', 'Xatcho''p nima? U nima vazifani bajaradi?', 'Xatcho''p bu\r\nOdnoklassniki.ru saytidan\r\nfoydalanishda sizu-bizga\r\nyaratilgan qulayliklardan\r\nbiri bo''lib bu bilan biz\r\nodnoklassniki.ru saytida "Tez qulay, oson, samarali va shu bilan birga ozmuncha Trafikni tejash imkoniyatiga ega bo''lamiz. Xo''p Xatcho''p ning qulayliklari xaqida\r\ngaplashib oldik endi esa uni qanday maqsadlarda foydalanish to''g''risida\r\ngaplashamiz. Demak,\r\nboshladik. Odnoklassniki.ru saytida biror bir do''stimiz bizga\r\nkerak uni oson Yoki biror bir guruh yoki undagi biror mavzu s', 'admin', 1, 1, 1, 1, 0, 1443099543),
(2, 1, 'SALOM qadrli saytimiz\r\nfoydalanuvchilari bugun men\r\nsizlarga odnoklassniki saytida\r\nbizga necha kishi gosti (yani:\r\nMEXMON) bolganligini\r\naniqlashni örgataman albatta\r\nbu qiziq tuyulishi mumkin\r\nqanday qilib deysizmi unda\r\nmaqolani diqqat bilan öqib\r\nchiqing. Buning uchun bizga 4.2\r\n5.0 5.6 va undan yuqori bolgan\r\nopera mini dasturi kerak boladi\r\nagar u sizda yöq bolsa unda\r\nmanabu joydan yuklab oling.\r\n19:08 Yosh akademik DEMAK,\r\nboshladik ok.rusaytiga kiramiz\r\nva töliq versiyaga ötamiz\r\nuyerdan mexmonlar belgisi\r\nustiga bosamiz va yangi oyna\r\nochiladi va uyerda qator\r\nmexmonlar royxati k6rinadi va\r\nteparoqda "MENING\r\nMEXMONLARIM yozuvi ga\r\nk6zimiz tuwadi vayonida\r\nmexmonlar soni turadi (MENING\r\nMEXMONLARIMG 250) wunday\r\ntarzda bizga necha kishi\r\nmexmon bolganligini\r\naniqlashimiz mumkin. . Bu\r\nmaqola xech bir saytda yöq va\r\nxech qanday manbalardan\r\nfoydalanilmadi', 'ODNOKLASSNIKI SAYTIDA MEXMONLAR SONINI ANIQLASH', 'SALOM qadrli saytimiz\r\nfoydalanuvchilari bugun men\r\nsizlarga odnoklassniki saytida\r\nbizga necha kishi gosti (yani:\r\nMEXMON) bolganligini\r\naniqlashni örgataman albatta\r\nbu qiziq tuyulishi mumkin\r\nqanday qilib deysizmi unda\r\nmaqolani diqqat bilan öqib\r\nchiqing. Buning uchun bizga 4.2\r\n5.0 5.6 va undan yuqori bolgan\r\nopera mini dasturi kerak boladi\r\nagar u sizda yöq bolsa unda\r\nmanabu joydan yuklab oling.\r\n19:08 Yosh akademik DEMAK,\r\nboshladik ok.rusaytiga kiramiz\r\nva töliq versiyaga ötamiz\r\nuyerda', 'admin', 1, 1, 1, 1, 0, 1443108660),
(3, 1, 'Salom döstlar bugun men\r\nsizlarga 1ta MOBILE AGENTDAN\r\nbir nechta profilni boshqarishni\r\nörgataman. Avvalgi\r\nmaqolalarda 1ta Agent\r\ndasturidan 1ta profilni\r\nboshqarish haqida keltirilgan\r\nedi Bugun men sizlarga bitta\r\nAgent dasturi orqali birnechta\r\nmail.rupochta xamda\r\nOdnoklassnikidagi bir nechta\r\nprofilni boshqarishni\r\nörgataman. Buning uchun bizga\r\nMOBILE AGENT dasturi kerak\r\nböladi. Demak, boshladik\r\navvalo biz AGENT DASTURI ga\r\nkiramiz va MENYU ni bosamiz\r\nva yang oyna ochiladi uyerdan\r\nНАСТРОЙКИЬ ni ustiga bosamiz\r\nyana yang oyna ochiladi\r\nuyerdan УЧЕТНИЕ ЗАПИСИ\r\nyozuvi ustiga bosamiz yangi\r\nochna ochiladi uyerdan\r\nДобавит запиcиь\r\nOдноклассники yozuvi ustiga\r\nbosamiz oyna ochiladi va\r\nkiritmoqchi bölgan profilimizni\r\n1-katakchaga login 2-\r\nkatakchaga parolimizni\r\nyozamiz va СОХРАНИТЬ\r\ntugmasi bosamiz va tayyor.\r\nEndi yana boshqa profilizni\r\nqöshmoqchi bölsak va yana\r\nösha tepadagi amallarni\r\nДобавит запиcиь\r\nOдноклассники yozuvi ustiga\r\nbosamiz oyna ochiladi va\r\nkiritmoqchi bölgan profilimizni\r\n1-katakchaga login 2-\r\nkatakchaga parolimizni\r\nyozamiz va СОХРАНИТЬ\r\ntugmasi bosamiz va tayyor.\r\nSHunday qilib biz bitta agent\r\ndasturi orqali birnechta profilni\r\nboshqarishimiz mumkin.', 'BITTA AGENT DASTURIDAN BIRNECHTA PROFILNI BOSHQARISH', 'Salom döstlar bugun men\r\nsizlarga 1ta MOBILE AGENTDAN\r\nbir nechta profilni boshqarishni\r\nörgataman. Avvalgi\r\nmaqolalarda 1ta Agent\r\ndasturidan 1ta profilni\r\nboshqarish haqida keltirilgan\r\nedi Bugun men sizlarga bitta\r\nAgent dasturi orqali birnechta\r\nmail.rupochta xamda\r\nOdnoklassnikidagi bir nechta\r\nprofilni boshqarishni\r\nörgataman. Buning uchun bizga\r\nMOBILE AGENT dasturi kerak\r\nböladi. Demak, boshladik\r\navvalo biz AGENT DASTURI ga\r\nkiramiz va MENYU ni bosamiz\r\nva yang oyna ochiladi uyerdan\r\nНА', 'admin', 1, 1, 1, 1, 0, 1443108684),
(4, 1, 'Salom döstlar bugun men\r\nsizlarga odnoklassni saytida\r\nqanday qilib 6z sahifamizni\r\nbezatishni örgataman Buning\r\nuchun bizga 5.1 6.0 6.5 va\r\nundan yuqori bölgan opera mini\r\ndasturikerak böladi agar u\r\nsizda yöq bölsa saytimizdan\r\nyuklab olishingiz mumkin.\r\nDemak, boshladik biz avvalo\r\nopera mini dasturidan ok.ru\r\nsaytiga kiramiz va töliq\r\nversiyaga ötamiz va eng\r\ntepada ekranning öng\r\ntarafidagi "Qöshimcha" yozuvi\r\nustiga bosamiz saxifa\r\nyangilanadi va ekranning o''ng\r\ntarafida kichkina oynacha\r\nochiladi uyerdan "BEZATISH\r\nUSULLARI" yozuvi ustiga\r\nbosamiz yangi oyna ochiladi.\r\nUyerdan qator temalar (ya''ni\r\nrasimlar) royxati chiqadi va\r\nözimizga yoqqan biror temani\r\ntanlaymiz va ustiga bosamiz\r\nyangi oyna ochiladi uyerdan\r\n"ÖRNATISH" tugmasi ustiga\r\nbosamiz va tayyor qarabsizki\r\nbizning saxifamiz chiroyli\r\nkörinisga keldi. Eslatma: ushbu\r\nbezatgan saxifamizni\r\nkompyuter orqali töliq\r\nkörishimiz mumkin telefon\r\norqali ma''lum bir qismi körinadi\r\nxalos. Bu maqola xali xech bir\r\nsaytda yöq Maqolani shaxsan\r\nADMIN MASTER Qora Lochin\r\nxech qaysi saytdan va xech\r\nqanday manbaalardan\r\nfoydalanmagan xolda\r\ntayyorladi.', 'ODNOKLASSNIKI SAYTIDA SAXIFANI BEZATISH (new)', 'Salom döstlar bugun men\r\nsizlarga odnoklassni saytida\r\nqanday qilib 6z sahifamizni\r\nbezatishni örgataman Buning\r\nuchun bizga 5.1 6.0 6.5 va\r\nundan yuqori bölgan opera mini\r\ndasturikerak böladi agar u\r\nsizda yöq bölsa saytimizdan\r\nyuklab olishingiz mumkin.\r\nDemak, boshladik biz avvalo\r\nopera mini dasturidan ok.ru\r\nsaytiga kiramiz va töliq\r\nversiyaga ötamiz va eng\r\ntepada ekranning öng\r\ntarafidagi "Qöshimcha" yozuvi\r\nustiga bosamiz saxifa\r\nyangilanadi va ekranning o''ng\r\ntarafida kichkina oynacha\r\n', 'admin', 1, 0, 1, 1, 0, 1443108714),
(5, 1, 'Salom döstlar bugun men\r\nsizlarga "TELEFONDA PROFILNI\r\nÖCHIRISHNI sirni örgataman bu\r\nmaqola xali xech bir saytda yöq\r\nva xech qayerdan köchiril\r\n(...)alardan foydalanmagan\r\nxolda maqolani shaxsan özim\r\ntayorladim m.ok.ru/qora.lochin\r\nDemak, boshladik buning uchun\r\nbiz avvalo MAIL.RU ga kirib\r\nbrowser yuklab olamiz va ösha\r\nbrowserdan Ok.ru saytiga\r\nkiramiz va töliq versiyaga\r\nötamiz eng pastda . Tilni\r\nözgartrish mobil versiya\r\nreklama guruxlar özim xaqimda\r\nREGLAMENTva hokazo yozuvlar\r\nchiqadi ular ichidan REGLAMENT\r\nustiga bosamiz yang saxifa\r\nochiladi uyerda sayt xaqidagi\r\nmalumotlar berilgan va eng\r\npatga tushamiz uyerda keyng\r\nsaxafiga ötish belgisi bor öshani\r\nbosamizyana yang oyna\r\nochiladi yana pastga tuwamiz\r\nkeyng saxifaga ötsh tugmasini\r\nbosamiz buni to manabu yozuv\r\nchiqgunga qadar keyng\r\nsaxifapa ötishni davom\r\nettiramiz 11.7. По вопросам,\r\nсвязанным с исполнением\r\nСоглашения, просьба\r\nобращаться по адресу\r\nместонахождения\r\nЛицензиара: Российская\r\nФедерация, 125167 г. Москва,\r\nЛенинградский проспект, д.\r\n39, строение 79. Редакция от\r\n«27» октября 2014 года .\r\nQöllab quvatlash xizmatiga\r\nmurojat qilish: ОТКАЗАТЬСЯ ОТ\r\nУСЛУГУ7\r\n____________________________________\r\nözbektili guruxlar\r\nmuxokamalar vakansiya\r\nyordam reglament mobil\r\nversiya wunga öxshash\r\nyozuvlar chiqadi . Uyerdan\r\n""ОТКАЗАТЬСЯ ОТ УСЛУГУ""\r\nmana bu yozuv ustiga bosamiz\r\nva sahifa yangilanadi eng\r\npastga tuwamiz va keyng\r\nsaxifaga ötish tugmasini\r\nbosamiz yang oyna ochiladi\r\nuyerda nima sababdan\r\nöchirmoqchi bölyotganimiz\r\nhaqidagi punktlardan biriga\r\nbelglaymz va pastga tushamz\r\nuyerda parol kritis uchun joy\r\nchiqadi va parolni kiritib\r\nBUTUNLAY ÖCHIRISH tugmasini\r\nbosamiz va tamom. ADMIN\r\nMASTER Qora Lochin(...)i\r\nmualliflik xuquqi va Sayt nomi\r\nkeltirilgan xolda\r\nköchirilshi\r\nshart xammaga omad', 'TELEFONDA PROFILNI UDALIT QILISH', 'Salom döstlar bugun men\r\nsizlarga "TELEFONDA PROFILNI\r\nÖCHIRISHNI sirni örgataman bu\r\nmaqola xali xech bir saytda yöq\r\nva xech qayerdan köchiril\r\n(...)alardan foydalanmagan\r\nxolda maqolani shaxsan özim\r\ntayorladim m.ok.ru/qora.lochin\r\nDemak, boshladik buning uchun\r\nbiz avvalo MAIL.RU ga kirib\r\nbrowser yuklab olamiz va ösha\r\nbrowserdan Ok.ru saytiga\r\nkiramiz va töliq versiyaga\r\nötamiz eng pastda . Tilni\r\nözgartrish mobil versiya\r\nreklama guruxlar özim xaqimda\r\nREGLAMENTva hokazo yozuvlar\r\nchiqadi', 'admin', 1, 0, 1, 1, 0, 1443108778),
(6, 1, 'Bu maqolamizda chornida turib sms\r\nyozishni o''rganamiz. Demak boshladik.\r\nAvvalambor sizda android telefon\r\nkerak bo''ladi. Telefonda Odnoklassniki.Ru\r\nProgrammasi kerak. Albatta bir Dona boshqa Profil va uni\r\nDruzyasida siz bo''lishingiz kerak.\r\nDemak boshladik. Chorni qilgan bolani nikini kopirovat qilamiz. Odno programmasiga kiramiz. Do''st qidirishdan vstavit qilib qidiramiz. Lichkasiga kirib Chat\r\nyaratamiz. Oyna ochilib do''stlaringizni qo''shish chiqadi\r\nva o''zingizni profilingizni qo''shib\r\nChatni yaratamiz. Qarabsizki be''malol chornidan turib lichkaga sms jo''nataolasiz.\r\nMana bu maqolani Ustozim Musajon tayyorladi. Bilmasvoy.Ru\r\nuchun maxsus. Yordam\r\ntekganidan xursandmiz.\r\nHammaga omad.', 'Qora Ro''yhatdan (Chorni Spiskadan) Chiqish Siri! (Android Uchun)', 'Bu maqolamizda chornida turib sms\r\nyozishni o''rganamiz. Demak boshladik.\r\nAvvalambor sizda android telefon\r\nkerak bo''ladi. Telefonda Odnoklassniki.Ru\r\nProgrammasi kerak. Albatta bir Dona boshqa Profil va uni\r\nDruzyasida siz bo''lishingiz kerak.\r\nDemak boshladik. Chorni qilgan bolani nikini kopirovat qilamiz. Odno programmasiga kiramiz. Do''st qidirishdan vstavit qilib qidiramiz. Lichkasiga kirib Chat\r\nyaratamiz. Oyna ochilib do''stlaringizni qo''shish chiqadi\r\nva o''zingizni profilingizni qo''shib\r\nCh', 'admin', 1, 0, 1, 1, 0, 1443108801),
(7, 1, 'Bugun sizlar bilan ana shu\r\nvazifalar to''g''risida gaplashamiz!\r\nKo''pchiligingiz bundan xabardor\r\nbo''lishingiz mumkin,lekin\r\nboshqalar esa bilmasligi mumkin!\r\nBoshladik, siz o''z profilingizdagi\r\nboshqa sahifalar, u yerdan esa\r\nyutuqlarim bo''limiga o''tsangiz\r\nturli dostijeniyalarga ko''zingiz\r\ntushadi. Bular sizni\r\nodnoklassnikida ixtiyoriy ravishta\r\nbajarishingiz mumkin bo''lgan\r\nvazifalar. Bu vazifalarni har birini\r\nbajarsangiz sayt sizga ochko\r\n(ball)lar beradi. Sizda ana shu\r\nochkolarni to''plangan bo''lsa\r\nsaytning to''liq versiyasida Kim\r\noshdi savdosida qatnashishingiz\r\nyoki bepul ok larga\r\nalmashtirishingiz mumkin.\r\nVazifalarni qancha ko''p\r\nbajarsangiz to''plangan ochkolar\r\nsoni oshaveradi. Keyin alishtirgan\r\nOklaringizga siz sevgan\r\nxizmatlarni bemalol\r\nyoqtirishingiz mumkin bo''ladi.', 'Odnoklasnikidagi vazifalar haqida qisqacha ma''lumot!', 'Bugun sizlar bilan ana shu\r\nvazifalar to''g''risida gaplashamiz!\r\nKo''pchiligingiz bundan xabardor\r\nbo''lishingiz mumkin,lekin\r\nboshqalar esa bilmasligi mumkin!\r\nBoshladik, siz o''z profilingizdagi\r\nboshqa sahifalar, u yerdan esa\r\nyutuqlarim bo''limiga o''tsangiz\r\nturli dostijeniyalarga ko''zingiz\r\ntushadi. Bular sizni\r\nodnoklassnikida ixtiyoriy ravishta\r\nbajarishingiz mumkin bo''lgan\r\nvazifalar. Bu vazifalarni har birini\r\nbajarsangiz sayt sizga ochko\r\n(ball)lar beradi. Sizda ana shu\r\nochkolarni to''plang', 'admin', 1, 0, 1, 1, 0, 1443108844),
(8, 1, 'Salom do''stlar bugun men sizlar\r\nbilan Elektron pochtaning\r\nafzalliklari xaqida gaplashamiz.\r\nDemak boshladik.\r\nElektron pochtaning afzalligi\r\nshuki.\r\nSiz biror bir saytdan ro''yxatdan\r\no''tdingz masalan ok.rudan va\r\nparolingiz esdan chiqdi profil\r\nochilgan nomeringiz kuyib ketdi,\r\nyoki yo''qoldi, yoki biror kishi\r\nishlatyabdi bunda sizga\r\nELEKTRON pochta yordamga\r\nkeladi va siz pochtangiz orqali\r\nprofilingizni tiklashingz mumkin\r\nbo''ladi buning albatta elektron\r\npochtangizni profilingizga\r\nbiriktirgan bo''lishingz kerak.\r\nSiz Beelline abonentisiz va siz\r\nok.rudan kelgan xabarni\r\ntelefoningiz orqali bilmoqchisiz\r\nbunda ham sizga elektron pochta\r\nasqotadi. Buning uchun elektron\r\npochtangizni profilingizga\r\nbiriktirasiz va bildirishnomalarni\r\nsozlaysiz va Mail.ruga kirib\r\nelektron pochtangizga o''sha\r\nishlatayotgan raqamingzni\r\nkiritasiz va bildirishnomalarni\r\nsozlaysiz va bemalol\r\nfoydalanishingiz mumkin.\r\n.\r\nELEKTRON pochtaning eng\r\nmuhim qulayliklaridan biri bu bir\r\nnechta saytdagi kelgan\r\nxabarlarningzni bir joyda\r\nto''plash imkonini beradi misol\r\nuchun\r\n"Odnoklassniki"\r\n"Facebook"\r\n"Twitter"\r\n"Spaces" va boshqa ko''plab\r\nsaytlardan kelgan xabarlarni\r\nxullas qaysi bir saytdan\r\nro''yxatdan o''tganingizda\r\nelektron pochtangzni kiritgan\r\nbo''lsangiz barcha profilingizga\r\nkelgan xabarni ELEKTRON\r\nPOCHTAngiz orqali bilishingz\r\nmumkin böladi.\r\nYana elektron pochta hosting,\r\ndomen, konstruktorlar uchun\r\nham kerak. Ya''ni ularni parolini\r\nyo''qotsangiz tiklab beradi.\r\nPochtaga 3 oyda 1 marta\r\nkirmasangiz pochta o''chib ketdi.\r\nExtiyot bo''ling pochtani vzlom\r\nqilish juda oson. Murakkab\r\nparoldan qo''ying. Masalan meni\r\nparolimdan-516,279.3m1 buni\r\nhackerlar buzolmaydi. Emailiz\r\nya''ni pochtayizni oldirib\r\nqo''ysangiz hamma elektron\r\npochtaga kirgizgan saytlar vzlom\r\nbo''ladi maslahatim. Gmail.com\r\ndan foydalaning.\r\nMaqolada xatoliklar bo''lsa uzur\r\nso''rayman', 'Elektron pochtaning qulayliklari!', 'Salom do''stlar bugun men sizlar\r\nbilan Elektron pochtaning\r\nafzalliklari xaqida gaplashamiz.\r\nDemak boshladik.\r\nElektron pochtaning afzalligi\r\nshuki.\r\nSiz biror bir saytdan ro''yxatdan\r\no''tdingz masalan ok.rudan va\r\nparolingiz esdan chiqdi profil\r\nochilgan nomeringiz kuyib ketdi,\r\nyoki yo''qoldi, yoki biror kishi\r\nishlatyabdi bunda sizga\r\nELEKTRON pochta yordamga\r\nkeladi va siz pochtangiz orqali\r\nprofilingizni tiklashingz mumkin\r\nbo''ladi buning albatta elektron\r\npochtangizni profilingizga\r\nbirikti', 'admin', 1, 0, 1, 1, 0, 1443108886),
(9, 1, 'Salom dostlar bugun men\r\nsizlarga "telefonda guruxingizga\r\nSilka tayyorlashni " örgataman bu\r\nmaqola xali xech bir saytda yöq.\r\nbuning uchun bizga 4.2\r\nversiyadagi opera yoki Mail.ru\r\ndan Browser yuklab olishimiz\r\nkerak b6ladi.\r\nDemak, boshladik, avvalam bor\r\nok.ru saytiga kiramiz va töliq\r\nya''ni kompyuter versiyaga ötamiz\r\n.\r\ntepada Asosiy, Döstlar,\r\nFotosuratlar, Guruxlar, Qaydlar va\r\nhokazo.\r\n.\r\nShu yerdan GURUHLAR degan\r\nyozuv ustiga bosamiz va guruhlar\r\nroyhati chiqadi. Uyerdan (silka\r\ntayorlamoqchi bölgan)\r\nGuruximizni topib ustiga\r\nbosamiz\r\nyang oyna ochiladi va ekranning\r\nchap tarafida guruhimizning\r\nasosiy fotosurati chiqadi tagida\r\n.\r\n(eslatib otaman silkani tayorlash\r\nuchun siz gurux admini\r\nbölishingz kerak)\r\n.\r\nDöstlarni taklif qilish\r\nFotokonkusr uyuwtrish\r\n"PARAMETRLARNI ÖZGARTRISH"\r\nTasmadan olib tashlash va\r\nhokazo.\r\nShu yerdan "PARAMETRLARNI\r\nÖZGARTRISH" degan yozuv ustiga\r\nbosamiz yangi oyna ochiladi\r\nuyerdan\r\n"guruhga bölgan havola" degan\r\njoyni topamiz uyerda\r\nmanabunday yozuv chiqadi\r\nm.odnoklassniki.ru/grup/12757\r\n.\r\nm.odnoklasniki.ru/guruxinga\r\nnom kiriting\r\nMasalan:\r\nhttp://m.ok.ru/\r\nodnoklassnikixxsirlari\r\n. Keyn "saqlash" tugmasini\r\nbosing va guruximiz un silka\r\ntayyor.\r\nMen qoldan kelgancha soddaroq\r\nqlib tuwuntrishga xarakat qildim.\r\nXATOlar bölsa uzur sörayman.', 'Telefonda Guruh uchun sillka tayyorlash!', 'Salom dostlar bugun men\r\nsizlarga "telefonda guruxingizga\r\nSilka tayyorlashni " örgataman bu\r\nmaqola xali xech bir saytda yöq.\r\nbuning uchun bizga 4.2\r\nversiyadagi opera yoki Mail.ru\r\ndan Browser yuklab olishimiz\r\nkerak b6ladi.\r\nDemak, boshladik, avvalam bor\r\nok.ru saytiga kiramiz va töliq\r\nya''ni kompyuter versiyaga ötamiz\r\n.\r\ntepada Asosiy, Döstlar,\r\nFotosuratlar, Guruxlar, Qaydlar va\r\nhokazo.\r\n.\r\nShu yerdan GURUHLAR degan\r\nyozuv ustiga bosamiz va guruhlar\r\nroyhati chiqadi. Uyerdan (silka\r\ntayo', 'admin', 1, 0, 1, 1, 0, 1443108927),
(10, 1, 'Mana bugun ertalab ok.ru da\r\no''tirib ok.ru yangi smailiklarini\r\ntopib oldim. To''g''ri bu uncha\r\nkatta ish emas ammo\r\nsaytdagilarga asqotsa\r\nxursandman. Elyorbek do''stimni\r\nbir maqolasida shunday degandi\r\nok.ru yangi smailiklar chiqdi.\r\nAlbatta u smailiklarni topsak\r\nParvoz.Com da aytamiz degandi.\r\nMana smailiklar 35 dona yana\r\ntopsak joylab qo''yamiz.\r\nHammaga omad.\r\n1-♠\r\n2-♥\r\n3-♣\r\n4-♦\r\n5-☀\r\n6-✈\r\n7-♋\r\n8-✌\r\n9-✌\r\n10-♒\r\n11-★\r\n12-☁\r\n13-♬\r\n14-✂\r\n15-✉\r\n16-✔\r\n17-⁉\r\n18-☝\r\n19-✳\r\n20-✴\r\n21-❄\r\n22-❇\r\n23-♬\r\n24-Ⓜ\r\n25-▶\r\n26-◀\r\n27-‼\r\n28-✏\r\n29-✒\r\n30-☑\r\n31-▪\r\n32-▫\r\n33-☎\r\n34-⌚\r\n35-⌛', 'Yangicha Smailiklar Telda (35 dona)', 'Mana bugun ertalab ok.ru da\r\no''tirib ok.ru yangi smailiklarini\r\ntopib oldim. To''g''ri bu uncha\r\nkatta ish emas ammo\r\nsaytdagilarga asqotsa\r\nxursandman. Elyorbek do''stimni\r\nbir maqolasida shunday degandi\r\nok.ru yangi smailiklar chiqdi.\r\nAlbatta u smailiklarni topsak\r\nParvoz.Com da aytamiz degandi.\r\nMana smailiklar 35 dona yana\r\ntopsak joylab qo''yamiz.\r\nHammaga omad.\r\n1-♠\r\n2-♥\r\n3-♣\r\n4-♦\r\n5-☀\r\n6-✈\r\n7-♋\r\n8-✌\r\n9-✌\r\n10-♒\r\n11-★\r\n12-☁\r\n13-♬\r\n14-✂\r\n15-✉\r\n16-✔\r\n17-⁉\r\n18-☝\r\n19-✳\r\n20-✴\r\n21-❄\r\n22-❇\r\n23-♬\r\n24-', 'admin', 1, 0, 1, 1, 0, 1443109446),
(11, 1, 'Demak bu maqolani hech qanaqa\r\nsaytdan olmayabman. Maqolani\r\ntayyorlashga yordam bergan\r\nodam Joxa.Frenkly (Jahongir aka)\r\nga minnatdorchilik bildiraman.\r\nSiz Zakrid qilingan Guruhga\r\nkirdingiz. Ammo nechta\r\nfoydalanuvchi borligini\r\nko''rmoqchisiz ammo\r\nko''rolmadiz. Shunda siz Guruhni\r\nnomini ko''chirib olib ''''Odam va\r\nGuruhlar ni izlashga ko''chirgan\r\nso''zni Vstavit qilasiz va qidirasiz.\r\nQarabsizki Guruh\r\nfoydalanuvchilari chiqib turadi.\r\nBuning uchun albatta 5.1 dan\r\nyuqori opera mini bo''lishi lozim.\r\nMaqola kimgadur foydasi tekkan\r\nbo''lsa hursandman.', 'Yopiq Guruhni Foydalanuvchilarini topish (telda)', 'Demak bu maqolani hech qanaqa\r\nsaytdan olmayabman. Maqolani\r\ntayyorlashga yordam bergan\r\nodam Joxa.Frenkly (Jahongir aka)\r\nga minnatdorchilik bildiraman.\r\nSiz Zakrid qilingan Guruhga\r\nkirdingiz. Ammo nechta\r\nfoydalanuvchi borligini\r\nko''rmoqchisiz ammo\r\nko''rolmadiz. Shunda siz Guruhni\r\nnomini ko''chirib olib ''''Odam va\r\nGuruhlar ni izlashga ko''chirgan\r\nso''zni Vstavit qilasiz va qidirasiz.\r\nQarabsizki Guruh\r\nfoydalanuvchilari chiqib turadi.\r\nBuning uchun albatta 5.1 dan\r\nyuqori opera mini bo''lishi l', 'admin', 1, 0, 1, 1, 0, 1443109476),
(12, 1, 'Bu maqoladagi ma''lumot\r\narzimasa ham sizlar bilan baham\r\nko''rmoqchiman\r\nHullas sizning Guruhingiz bor va\r\nmavzularingizni qatnashchilar\r\nmuhokama qilayapti lekin\r\nmavzuga so''kinib yoki\r\nhaqoratlab komment yozadigan\r\nqatnashchilar ham uchrab turadi\r\nagar siz mavzuingizga komment\r\nyozishlarini hohlamasangiz\r\ntelefon orqali ham muhokamani\r\nyopish mumkin.\r\n1. Saytning To''liq versiyasiga\r\no''tamiz\r\n2. Guruhlar bo''limiga kiramiz.\r\n3. Guruhimizga kirib\r\n4. Mavzularga kiramiz va mavzu\r\npastidagi o''ng tarafida\r\n"Sharhlarni o''chirish" ga bir\r\nmarta bosamiz va "Sharhlarni\r\nyoqish" bo''lib qoladi hohlasangiz\r\nyana bir marta bosib\r\nmuhokamani ochishingiz\r\nmumkun\r\nAgar telefongiz to''liq versiyada\r\nishlashi qiyinlashsa\r\nBrouzerimizdan Rasmlarni\r\nko''rsatishni o''chirib qo''yib\r\nishlashni maslahat beraman\r\nYordamimiz tekganidan\r\nxursandmiz', 'Guruhdagi mavzularning Muhokamasini Yopish', 'Bu maqoladagi ma''lumot\r\narzimasa ham sizlar bilan baham\r\nko''rmoqchiman\r\nHullas sizning Guruhingiz bor va\r\nmavzularingizni qatnashchilar\r\nmuhokama qilayapti lekin\r\nmavzuga so''kinib yoki\r\nhaqoratlab komment yozadigan\r\nqatnashchilar ham uchrab turadi\r\nagar siz mavzuingizga komment\r\nyozishlarini hohlamasangiz\r\ntelefon orqali ham muhokamani\r\nyopish mumkin.\r\n1. Saytning To''liq versiyasiga\r\no''tamiz\r\n2. Guruhlar bo''limiga kiramiz.\r\n3. Guruhimizga kirib\r\n4. Mavzularga kiramiz va mavzu\r\npastidagi o''ng tar', 'admin', 1, 0, 1, 1, 0, 1443109495),
(13, 1, 'Odnoklassniki ru - sotsial seti\r\n2006-yilning mart oyidan\r\nboshlab ishga tushdi\r\nodnoklassniki/ru dan 1- bölib\r\nröyxatdan ötkan odam "Алберт\r\nПопков" (ok.ru asoschisi) global\r\nsotsial setning asoschisi\r\n''''Альберт Попков'''' janoblari.\r\nodnoklassniki sayti töliq ishga\r\ntushgan kun 26 - mart 2006 -\r\nyil. / OK.ru saytining hozirgi\r\nkundagi boshqaruvchisi (admini)\r\nИлья Широков\r\nhisoblanadi!\r\n''''Альберт Попков'''' profili- ok.ru/profile/702176104', 'Odnoklassniki.ru Admini Kim?', 'Odnoklassniki ru - sotsial seti\r\n2006-yilning mart oyidan\r\nboshlab ishga tushdi\r\nodnoklassniki/ru dan 1- bölib\r\nröyxatdan ötkan odam "Алберт\r\nПопков" (ok.ru asoschisi) global\r\nsotsial setning asoschisi\r\n''''Альберт Попков'''' janoblari.\r\nodnoklassniki sayti töliq ishga\r\ntushgan kun 26 - mart 2006 -\r\nyil. / OK.ru saytining hozirgi\r\nkundagi boshqaruvchisi (admini)\r\nИлья Широков\r\nhisoblanadi!\r\n''''Альберт Попков'''' profili- ok.ru/profile/702176104', 'admin', 1, 0, 1, 1, 0, 1443109535),
(14, 1, 'Profilingiz ochilgan raqamni\r\nyo''qotdingiz, yoki raqamni\r\nsindirib tashladingizmi? Sizga\r\nbu\r\nholat xavf tug''diradi. Bilamizki\r\nraqamlar yana sotuvga\r\nchiqariladi. Raqamni sotib olgan\r\nkishi profilizni tiklab olib,\r\nsizning\r\ntanishlaringiz oldidagi\r\nxurmatingizni < 0 >qilib qo''yadi,\r\nBUNING UCHUN, siz profilizga\r\nyangi raqamizni kiritib\r\nqo''yishizni tavsiya etaman.\r\n"Boshqa bo''limlar" ga kirib\r\n"Parametrlar o''zgartirish"ga\r\nkirib\r\n"Tel nomer"ga kirasiz va\r\nraqamni\r\nkiritib kodni tasdiqlab, xavfdan\r\nqutilamiz. Hammaga omad!', 'Profilingiz Xavf Ostida!', 'Profilingiz ochilgan raqamni\r\nyo''qotdingiz, yoki raqamni\r\nsindirib tashladingizmi? Sizga\r\nbu\r\nholat xavf tug''diradi. Bilamizki\r\nraqamlar yana sotuvga\r\nchiqariladi. Raqamni sotib olgan\r\nkishi profilizni tiklab olib,\r\nsizning\r\ntanishlaringiz oldidagi\r\nxurmatingizni < 0 >qilib qo''yadi,\r\nBUNING UCHUN, siz profilizga\r\nyangi raqamizni kiritib\r\nqo''yishizni tavsiya etaman.\r\n"Boshqa bo''limlar" ga kirib\r\n"Parametrlar o''zgartirish"ga\r\nkirib\r\n"Tel nomer"ga kirasiz va\r\nraqamni\r\nkiritib kodni tasdiqlab, xavfd', 'admin', 1, 0, 1, 1, 0, 1443109560),
(15, 1, 'Salom Hurmatli Bilmasvoy.ru\r\nfoydalanuvchilari. Bu maqola\r\norqali sizga telda e''lonlarni tez\r\ntasdiqlashni urgataman, demak\r\nboshladik. Avvalo bizga UC\r\nBrowser kere, UC Browserdan\r\nok.ruga kiramiz. Undan kegin\r\ne''lonlarga kiramiz va lyuboy\r\ne''lonni tasdiqlaymiz. Zagruzka\r\nbulginicha ya''na bir nechasini\r\ntasdiqlaysiz qarabsizke e''lonlar\r\ntez va oson tasdiqlanadi', 'Telda E''lonlarni tez Tasdiqlash yo''li', 'Salom Hurmatli Bilmasvoy.ru\r\nfoydalanuvchilari. Bu maqola\r\norqali sizga telda e''lonlarni tez\r\ntasdiqlashni urgataman, demak\r\nboshladik. Avvalo bizga UC\r\nBrowser kere, UC Browserdan\r\nok.ruga kiramiz. Undan kegin\r\ne''lonlarga kiramiz va lyuboy\r\ne''lonni tasdiqlaymiz. Zagruzka\r\nbulginicha ya''na bir nechasini\r\ntasdiqlaysiz qarabsizke e''lonlar\r\ntez va oson tasdiqlanadi', 'admin', 1, 0, 1, 1, 0, 1443109585),
(16, 1, 'Siz o`zingizga yoki do`stingizga\r\nmaxsus sovg`a\r\nyubormoqchimisiz?\r\nSizda sovg`a yuborish uchun OK\r\nyetarlicha bor lekin qanday\r\nsovg`a yuborishni\r\nbilmayabsizmi?\r\nBunda sizga ushbu maqola as\r\nqotishi aniq. Buning uchun siz\r\nsovg`ani oldindan rasm tarzida\r\nyasab olishingiz kerak. Xajmi bir\r\nxil nisbatda bo`lishi kerak misol\r\n2x2 yoki 4x4 hajmda. Rasm\r\ntayyor ham bo`ldi deylik endi\r\nsiz\r\nkompyuterdan Odnoklassnikini\r\nto`liq versiyasiga o`ting va\r\nmenyular qismidan Sovg`lar\r\nbo`lmini tanlang. Endi siz ushbu\r\nbo`limning Foydalanuvchilar\r\nyaratgan sovg''alar qismidan\r\nsovg`a yaratishga bosing. Endi\r\nsiz\r\nsovg`a qilib yubormoqchi\r\nbo`lgan\r\nrasmni yuklang va o`zingiz\r\nhohlagan stilda bezak bering.\r\nSavol: Kompyuteri yo`qlar nima\r\nqilsin?\r\nJavob: Buning uchun siz sovg`a\r\nqilib yubormoqchi bo`lgan\r\nrasmni fotosuratlaringizga\r\nyuklab\r\noling va Internet klubda yoki\r\nboshqa joyda bemalol o`sha\r\nsovg`ani rasmlaringiz orasidan\r\nolib yuborishiz mumkin, siz\r\nyaratgan sovg`a boshqa\r\nsovg`alar\r\nnarxi bilan bir xil ya`ni 5 OK dir.\r\nHammaga omad!', 'Maxsus Sovg`a Yuborish Siri!', 'Siz o`zingizga yoki do`stingizga\r\nmaxsus sovg`a\r\nyubormoqchimisiz?\r\nSizda sovg`a yuborish uchun OK\r\nyetarlicha bor lekin qanday\r\nsovg`a yuborishni\r\nbilmayabsizmi?\r\nBunda sizga ushbu maqola as\r\nqotishi aniq. Buning uchun siz\r\nsovg`ani oldindan rasm tarzida\r\nyasab olishingiz kerak. Xajmi bir\r\nxil nisbatda bo`lishi kerak misol\r\n2x2 yoki 4x4 hajmda. Rasm\r\ntayyor ham bo`ldi deylik endi\r\nsiz\r\nkompyuterdan Odnoklassnikini\r\nto`liq versiyasiga o`ting va\r\nmenyular qismidan Sovg`lar\r\nbo`lmini tanlang. Endi', 'admin', 1, 0, 1, 1, 0, 1443109607),
(17, 1, 'Statusda do`stlarni belgilashni\r\nyangicha usuli . Har doimgidek\r\nbizga yana saytning to''liq\r\nversiyasidan kirish kerak\r\nbo''ladi.\r\nOdnoklassnikiga kirdik va Bosh\r\nsahifada turgan Qayd qo`shish\r\nga kiramiz va siz belgilamoqchi\r\nbo`lgan do`stlarimiz nikini\r\nqaydga yozamiz va shu zahoti\r\no`sha do`stizni manzili paydo\r\nbo`ladi so`ngra do`stiz ustiga\r\nbosasiz va do`stiz statusda\r\nbelgilanadi. Misol uchun http://\r\nhttp://m.ok.ru/AristokratFBI/statuses/62927583617159', 'Statusda do''stlarni belgilash usulli!', 'Statusda do`stlarni belgilashni\r\nyangicha usuli . Har doimgidek\r\nbizga yana saytning to''liq\r\nversiyasidan kirish kerak\r\nbo''ladi.\r\nOdnoklassnikiga kirdik va Bosh\r\nsahifada turgan Qayd qo`shish\r\nga kiramiz va siz belgilamoqchi\r\nbo`lgan do`stlarimiz nikini\r\nqaydga yozamiz va shu zahoti\r\no`sha do`stizni manzili paydo\r\nbo`ladi so`ngra do`stiz ustiga\r\nbosasiz va do`stiz statusda\r\nbelgilanadi. Misol uchun http://\r\nhttp://m.ok.ru/AristokratFBI/statuses/62927583617159', 'admin', 1, 0, 1, 1, 0, 1443109660),
(18, 1, 'Buning uchun Sizga saytning\r\nto`liq versiyasi kerak bo`ladi.\r\nUndan so`ng bosh sahifadagi\r\nXat ko`rinishidagi "Сообщения"\r\ntugmachasiga bosasiz.\r\nSizga oxirgi marotaba kimlar\r\nbilan yozishgan bo`lsangiz,\r\no`sha insonlar ro`yxati\r\nko`rsatiladi. U yerdan chat\r\nko`rinishida gaplashmoqchi\r\nbo`lgan bo`lajak\r\ndo`stlaringizdan brini ustiga\r\nbosasiz.\r\nShunda do`stingiz bilan\r\nyozishish mumkin bo`lgan\r\noynacha ochiladi. Bu\r\noynachaning yuqori qismidan\r\n"Добавить собеседников"\r\ndegan so`zni topib, ustiga\r\nsichqoncha kursori bilan\r\nbosasiz.\r\nQarshingizda kichkina\r\noynachada do`stlaringiz\r\nro`yxati\r\nnamayon bo`ladi. U yerda\r\nChatda\r\nyozishmoqchi bo`lgan\r\ndo`stlaringizni tanlab chiqasiz.\r\nBuning uchun ro`yxatdagi\r\ndo`stlaringiz ustiga bir\r\nmarotaba\r\nbosishingizni o`zi kifoya. Ular\r\navtomatik ravishda oynachani\r\nyuqori qismiga qo`shilib boradi.\r\nTanlab bo`lingandan so`ng quyi\r\nqisimdagi "Добавить"\r\ntugmachasini bosasiz. Endi Siz\r\nbir\r\nnecha do`stlaringiz\r\nbilan bemalol onlayn tarzida\r\nsuxbat qilishingiz mumkin. Agar\r\nyana do`stlar qo`shmoqchi\r\nbo`lsangiz qizil\r\nko`rsatkich orqali ko`rsatilgan,\r\nchap tarafdagi belgiga bosasiz.\r\nAgarda bu chatdan chiqish\r\nniyatingiz bo`lsa yuqori o`ng\r\ntarafdagi "Выйти" yozuviga\r\nbosasiz.', 'Odnoklassniki.Ru da Maroqli Suhbat Qurish!', 'Buning uchun Sizga saytning\r\nto`liq versiyasi kerak bo`ladi.\r\nUndan so`ng bosh sahifadagi\r\nXat ko`rinishidagi "Сообщения"\r\ntugmachasiga bosasiz.\r\nSizga oxirgi marotaba kimlar\r\nbilan yozishgan bo`lsangiz,\r\no`sha insonlar ro`yxati\r\nko`rsatiladi. U yerdan chat\r\nko`rinishida gaplashmoqchi\r\nbo`lgan bo`lajak\r\ndo`stlaringizdan brini ustiga\r\nbosasiz.\r\nShunda do`stingiz bilan\r\nyozishish mumkin bo`lgan\r\noynacha ochiladi. Bu\r\noynachaning yuqori qismidan\r\n"Добавить собеседников"\r\ndegan so`zni topib, ustiga\r', 'admin', 1, 0, 1, 1, 0, 1443109683),
(19, 1, 'Odnoklassniki Auksion\r\n- bu haqda hamma o''z fikriga\r\nega. Tajribamdan kelib chiqqan\r\nholda maslaxat bermoqchiman.\r\nAuksionda asosan ruslar faol\r\nbo''lishi sir emas. Sizga\r\nmaslaxatim shuki auksionda\r\nbiror nima sotib olmoqchimisiz\r\nbuning uchun eng qulay vaqt bu\r\nertalabki soat 4 dan 6 gacha\r\nbo''lgan vaqtdir. Sababi bu\r\nvaqtda\r\nxaridorlar soni juda kam\r\nbo''ladi.\r\nAuksionda narx qo''yishni eng\r\noxirgi 10 soniyada boshlang\r\nbunda ham ancha ochko\r\ntejaysiz.', 'Odnoklassnikida Auksion haqida!', 'Odnoklassniki Auksion\r\n- bu haqda hamma o''z fikriga\r\nega. Tajribamdan kelib chiqqan\r\nholda maslaxat bermoqchiman.\r\nAuksionda asosan ruslar faol\r\nbo''lishi sir emas. Sizga\r\nmaslaxatim shuki auksionda\r\nbiror nima sotib olmoqchimisiz\r\nbuning uchun eng qulay vaqt bu\r\nertalabki soat 4 dan 6 gacha\r\nbo''lgan vaqtdir. Sababi bu\r\nvaqtda\r\nxaridorlar soni juda kam\r\nbo''ladi.\r\nAuksionda narx qo''yishni eng\r\noxirgi 10 soniyada boshlang\r\nbunda ham ancha ochko\r\ntejaysiz.', 'admin', 1, 0, 1, 1, 0, 1443109712),
(20, 1, 'Buning uchun biz\r\nandroid telefonga agent\r\nprogrammasini yuklab\r\nolamiz. Keyin agentga\r\nlogin parolni terib saqlash\r\nqilib o''rtani (svernut)\r\nbosib chiqib ketamiz.\r\nQarabsizki siz 24 soat\r\nonlayn o''tirasiz. Ammo\r\nbuni yomon tarafi ham\r\nbor. Telefonda pulingiz\r\nbo''lmasa yoki zaryadkasi\r\nbo''lmasa odno o''chadi.\r\nBunda ko''p pul ketmaydi.\r\nTraffigingiz bo''lsa juda\r\nham kam ketadi. Sinalgan\r\nusul. Maqolani\r\ntayyorlashda yordam\r\nbergan After (Elmurod aka\r\nhacker) ga o''z\r\nminnatdorchiligimizni\r\nbildiramiz', 'Odnoklassniki.Ru saytida doimo Onlayn o''tirish siri.', 'Buning uchun biz\r\nandroid telefonga agent\r\nprogrammasini yuklab\r\nolamiz. Keyin agentga\r\nlogin parolni terib saqlash\r\nqilib o''rtani (svernut)\r\nbosib chiqib ketamiz.\r\nQarabsizki siz 24 soat\r\nonlayn o''tirasiz. Ammo\r\nbuni yomon tarafi ham\r\nbor. Telefonda pulingiz\r\nbo''lmasa yoki zaryadkasi\r\nbo''lmasa odno o''chadi.\r\nBunda ko''p pul ketmaydi.\r\nTraffigingiz bo''lsa juda\r\nham kam ketadi. Sinalgan\r\nusul. Maqolani\r\ntayyorlashda yordam\r\nbergan After (Elmurod aka\r\nhacker) ga o''z\r\nminnatdorchiligimizni\r\nbildiram', 'admin', 1, 0, 1, 1, 0, 1443109747),
(21, 1, 'Odatda odnoklassniki.ru saytiga\r\nopera\r\nminidan dasturidan kirib rasm\r\nyuklaymiz.\r\nLekin bu unchalik tez emas va\r\nfaqat 1 donadan yuklash\r\nmumkin.\r\nLekin biz sizga bugun birdaniga\r\n10 tadan100 tagacha rasm\r\nyuklashni o''rgatamiz. Buni\r\nko''pchilik biladi. ko''pchilik\r\nbilmaydi. Qani bo''lmasa\r\nboshladik.\r\nBirinchi navbatda mobilni\r\nodnoklassnikiga kiramiz. (agar\r\nu\r\nyo''q bo''lsa google play\r\nmarketdan yuklab oling).\r\nKirgandan keyin fotosuratlar\r\ndegan joyiga o''tamiz. U yerdan\r\nalbomni tanlab fotosuratlarni\r\nyuklash degan joyiga bosamiz.\r\nYuqorida o''ng tarafda kamera\r\ngalireya degan yozuvlar\r\nchiqadi. Undan galireyaga\r\nbosib uzizga kerakli fotolarni\r\nbelgilab qo''yasiz. Shunda\r\nsiz 10 tadan 100 tagacha\r\nfotolarni joylashtirishingiz\r\nmumkin bo''ladi. Hammaga\r\nomad.', '10 tadan 100 tagacha foto yuklash', 'Odatda odnoklassniki.ru saytiga\r\nopera\r\nminidan dasturidan kirib rasm\r\nyuklaymiz.\r\nLekin bu unchalik tez emas va\r\nfaqat 1 donadan yuklash\r\nmumkin.\r\nLekin biz sizga bugun birdaniga\r\n10 tadan100 tagacha rasm\r\nyuklashni o''rgatamiz. Buni\r\nko''pchilik biladi. ko''pchilik\r\nbilmaydi. Qani bo''lmasa\r\nboshladik.\r\nBirinchi navbatda mobilni\r\nodnoklassnikiga kiramiz. (agar\r\nu\r\nyo''q bo''lsa google play\r\nmarketdan yuklab oling).\r\nKirgandan keyin fotosuratlar\r\ndegan joyiga o''tamiz. U yerdan\r\nalbomni tanlab fotosur', 'admin', 1, 0, 1, 1, 0, 1443109798),
(22, 1, 'Odnoklassniki.ru da\r\nsiz biror do''stizgizni yoki biror\r\nkishini ro''yxatdan o''tgan\r\no''tmaganini bilmoqchimisiz,\r\nbuning uchun siz\r\nlogin yoki parolni unutdizmi\r\nqismiga o''ting va o''sha raqamni\r\nkiriting va natijani ko''ring. Agar\r\no''sha kishi ro''yxatdan o''tmagan\r\nbo''lsa, "Siz tomoningizdan\r\nko''rsatilgan login mavjud\r\nemas"\r\nyozuvi chiqadi. Eslatma: Siz\r\nqidirgan odam boshqa\r\nraqamdan\r\nham ro''yxatdan o''tgan bo''lishi\r\nmumkin.', 'Do''stingizni ro''yhatdan o''tgan o''tmaganini bilish.', 'Odnoklassniki.ru da\r\nsiz biror do''stizgizni yoki biror\r\nkishini ro''yxatdan o''tgan\r\no''tmaganini bilmoqchimisiz,\r\nbuning uchun siz\r\nlogin yoki parolni unutdizmi\r\nqismiga o''ting va o''sha raqamni\r\nkiriting va natijani ko''ring. Agar\r\no''sha kishi ro''yxatdan o''tmagan\r\nbo''lsa, "Siz tomoningizdan\r\nko''rsatilgan login mavjud\r\nemas"\r\nyozuvi chiqadi. Eslatma: Siz\r\nqidirgan odam boshqa\r\nraqamdan\r\nham ro''yxatdan o''tgan bo''lishi\r\nmumkin.', 'admin', 1, 0, 1, 1, 0, 1443109837),
(23, 1, 'Bu maqola bundan\r\noldingi maqolaga qisman\r\ndavomi.\r\nSiz biror kishini profiliga\r\nkirmoqchisiz. Buning uchun\r\no''sha kishini telefon raqami\r\nsizda\r\nbo''lishi kerak bo''ladi. Siz\r\n"Parolingiz yoki loginingizni\r\nunutdingizmi?" qismiga o''tib\r\no''sha registratsiya qilingan\r\nraqamni kiritasiz va pastdagi\r\nxavfsizlik kodini ham kiritib\r\nTiklash tugmasiga bosasiz. Va\r\nshu zaxoti o''sha raqamga 6 ta\r\nraqam boradi. So''ngra o''sha\r\nraqamlarni kiritib Kirish\r\ntugmasiga bosasiz va sizda\r\nyangi\r\nsaxifa ochiladi yangi parolni\r\nkiriting degan. Siz hech qanday\r\nparol kiritmasdan pastdagi\r\nOtmenit tugmasiga bosasiz\r\nshunda eski parol o''zgarmay\r\nqoladi va shu zaxoti o''sha\r\nraqamga ochilgan profilga kirib\r\nturibsiz.', 'Do''stingizni nomeriga profil ochilganmi?', 'Bu maqola bundan\r\noldingi maqolaga qisman\r\ndavomi.\r\nSiz biror kishini profiliga\r\nkirmoqchisiz. Buning uchun\r\no''sha kishini telefon raqami\r\nsizda\r\nbo''lishi kerak bo''ladi. Siz\r\n"Parolingiz yoki loginingizni\r\nunutdingizmi?" qismiga o''tib\r\no''sha registratsiya qilingan\r\nraqamni kiritasiz va pastdagi\r\nxavfsizlik kodini ham kiritib\r\nTiklash tugmasiga bosasiz. Va\r\nshu zaxoti o''sha raqamga 6 ta\r\nraqam boradi. So''ngra o''sha\r\nraqamlarni kiritib Kirish\r\ntugmasiga bosasiz va sizda\r\nyangi\r\nsaxifa ochiladi yan', 'admin', 1, 0, 1, 1, 0, 1443109859),
(25, 1, 'Bildirishnoma (Уведомления).\r\nBu ya`ni bildirishnoma haqida\r\nva\r\nuni foydali jihati haqida\r\nxabardorlar anchagina. Lekin\r\nbildirishnoma faqatgina ro''yhat\r\nqilingan raqamga sms tarzida\r\nboradi. Agar raqam boshqa\r\nbiron kishida bo''lsa nima qilish\r\nkerak. Bunday holatda bu\r\nmaqolamiz sizga as qotadi,\r\nqani\r\nboshladik. Avvalo mail.ru dan\r\nro''yxatdan o''tib, mail.rudagi\r\nbildirishnomani telefon\r\nraqamizga keladigan qilasiz.\r\nSo''ngra ok.ru dagi profilizga\r\nkirib mail.ru dagi pochtezni\r\nbiriktirasiz. Tayyor. Endi ok.ru\r\ndagi bildirishnomalar mail.ru\r\ndagi pochtezga, pochtezdagi\r\nbildirishnomalar telefonizga\r\nkeladi. Yordamim tekkan bo''lsa\r\nxursandman.', 'Bildirishnomani telefonga yuborish (tel raqam kerakmas)', 'Bildirishnoma (Уведомления).\r\nBu ya`ni bildirishnoma haqida\r\nva\r\nuni foydali jihati haqida\r\nxabardorlar anchagina. Lekin\r\nbildirishnoma faqatgina ro''yhat\r\nqilingan raqamga sms tarzida\r\nboradi. Agar raqam boshqa\r\nbiron kishida bo''lsa nima qilish\r\nkerak. Bunday holatda bu\r\nmaqolamiz sizga as qotadi,\r\nqani\r\nboshladik. Avvalo mail.ru dan\r\nro''yxatdan o''tib, mail.rudagi\r\nbildirishnomani telefon\r\nraqamizga keladigan qilasiz.\r\nSo''ngra ok.ru dagi profilizga\r\nkirib mail.ru dagi pochtezni\r\nbiriktirasiz. Ta', 'admin', 1, 0, 1, 1, 0, 1443109922),
(26, 1, 'Odnoklassniki tekin\r\nqo`ng`iroq. Bunda siz chet\r\ndavlat\r\nsafarida bo`lgan\r\nqarindoshlaringiz bilan bepul\r\nsuhbat qurishiz mumkin. Ya`ni\r\nsizni biror qarindoshiz Chet\r\ndavlatda telefon qilishgam\r\nimkoniyati yani mab`lag`i yo`q.\r\nBunday holatda siz\r\nodnoklassniki\r\nyordamga keladi. Buning uchun\r\nikkala insonda ham Andoroit\r\ntelefoni yoki Kompyuter bo`lsa\r\nkifoya, Androit telefonidan siz\r\nOndoklassnikki dasturi orqali\r\nodnoklassnikiga kirasiz. So`ngra\r\nsuxbat bo`limidan qo`ng`iroq\r\nqilmoqchi bo`lgan kishini\r\ntopasiz\r\nva usha kishida telefon\r\ngo`shagi\r\nbelgisiga bosasiz qarabsizki\r\nodnoklassniki orqali telefon\r\nqilib\r\nturibsiz. Bunda ham hisobizdan\r\npul ketadi lekin internet\r\nnarxida\r\nketadi. Siz bu usul orqali biri-\r\nbiringizni ko`rib gaplashishingiz\r\nham mumkin.', 'Odnoklassniki.Ru da Bepul qo''ng''iroq.', 'Odnoklassniki tekin\r\nqo`ng`iroq. Bunda siz chet\r\ndavlat\r\nsafarida bo`lgan\r\nqarindoshlaringiz bilan bepul\r\nsuhbat qurishiz mumkin. Ya`ni\r\nsizni biror qarindoshiz Chet\r\ndavlatda telefon qilishgam\r\nimkoniyati yani mab`lag`i yo`q.\r\nBunday holatda siz\r\nodnoklassniki\r\nyordamga keladi. Buning uchun\r\nikkala insonda ham Andoroit\r\ntelefoni yoki Kompyuter bo`lsa\r\nkifoya, Androit telefonidan siz\r\nOndoklassnikki dasturi orqali\r\nodnoklassnikiga kirasiz. So`ngra\r\nsuxbat bo`limidan qo`ng`iroq\r\nqilmoqchi bo`lgan', 'admin', 1, 1, 1, 1, 0, 1443109943);

--
-- Структура таблицы `library_tags`
--
DROP TABLE IF EXISTS `library_tags`;
CREATE TABLE `library_tags` (
  `id`          INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `lib_text_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `tag_name`    VARCHAR(255)     NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `lib_text_id` (`lib_text_id`),
  KEY `tag_name` (`tag_name`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_library_comments`
--
DROP TABLE IF EXISTS `cms_library_comments`;
CREATE TABLE `cms_library_comments` (
  `id`         INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `sub_id`     INT(11) UNSIGNED NOT NULL,
  `time`       INT(11)          NOT NULL,
  `user_id`    INT(11) UNSIGNED NOT NULL,
  `text`       TEXT             NOT NULL,
  `reply`      TEXT,
  `attributes` TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

--
-- Структура таблицы `cms_library_rating`
--
DROP TABLE IF EXISTS `cms_library_rating`;  
CREATE TABLE IF NOT EXISTS `cms_library_rating` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `st_id` int(11) NOT NULL,
  `point` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`st_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;  

--
-- Структура таблицы `news`
--
DROP TABLE IF EXISTS `news`;
CREATE TABLE IF NOT EXISTS `news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `avt` varchar(25) NOT NULL DEFAULT '',
  `name` text NOT NULL,
  `text` text NOT NULL,
  `kom` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;
  
INSERT INTO `news` (`id`, `time`, `avt`, `name`, `text`, `kom`) VALUES
(2, 1443106712, 'admin', 'Yangilik', 'Hurmatli saytimiz foydalanuvchilari endilikda saytimiz yanada rivojlanadi sababi saytimizga \r\nJohnCMS mod by M-Files001 o`rnatildi!', 0);

--
-- Структура таблицы `users`
--
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id`            INT(10) UNSIGNED    NOT NULL AUTO_INCREMENT,
  `name`          VARCHAR(25)         NOT NULL DEFAULT '',
  `name_lat`      VARCHAR(40)         NOT NULL DEFAULT '',
  `password`      VARCHAR(32)         NOT NULL DEFAULT '',
  `rights`        TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  `failed_login`  TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
  `imname`        VARCHAR(50)         NOT NULL DEFAULT '',
  `sex`           VARCHAR(2)          NOT NULL DEFAULT '',
  `komm`          INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `postforum`     INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `postguest`     INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `yearofbirth`   INT(4)              NOT NULL DEFAULT '0',
  `datereg`       INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `lastdate`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `mail`          VARCHAR(50)         NOT NULL DEFAULT '',
  `icq`           INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `skype`         VARCHAR(50)         NOT NULL DEFAULT '',
  `jabber`        VARCHAR(50)         NOT NULL DEFAULT '',
  `www`           VARCHAR(50)         NOT NULL DEFAULT '',
  `about`         TEXT                NOT NULL,
  `live`          VARCHAR(100)        NOT NULL DEFAULT '',
  `mibile`        VARCHAR(50)         NOT NULL DEFAULT '',
  `status`        VARCHAR(100)        NOT NULL DEFAULT '',
  `ip`            BIGINT(11)          NOT NULL DEFAULT '0',
  `ip_via_proxy`  BIGINT(11)          NOT NULL DEFAULT '0',
  `browser`       TEXT                NOT NULL,
  `preg`          TINYINT(1)          NOT NULL DEFAULT '0',
  `regadm`        VARCHAR(25)         NOT NULL DEFAULT '',
  `mailvis`       TINYINT(1)          NOT NULL DEFAULT '0',
  `dayb`          INT(2)              NOT NULL DEFAULT '0',
  `monthb`        INT(2)              NOT NULL DEFAULT '0',
  `sestime`       INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `total_on_site` INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `lastpost`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `rest_code`     VARCHAR(32)         NOT NULL DEFAULT '',
  `rest_time`     INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `movings`       INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `place`         VARCHAR(30)         NOT NULL DEFAULT '',
  `set_user`      TEXT                NOT NULL,
  `set_forum`     TEXT                NOT NULL,
  `set_mail`      TEXT                NOT NULL,
  `karma_plus`    INT(11)             NOT NULL DEFAULT '0',
  `karma_minus`   INT(11)             NOT NULL DEFAULT '0',
  `karma_time`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `karma_off`     TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `comm_count`    INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `comm_old`      INT(10) UNSIGNED    NOT NULL DEFAULT '0',
  `smileys`       TEXT                NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name_lat` (`name_lat`),
  KEY `lastdate` (`lastdate`),
  KEY `place` (`place`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;
  --
-- Структура таблицы `m_chat`
--

CREATE TABLE IF NOT EXISTS `m_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `message` varchar(500) NOT NULL,
  `cid` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Дамп данных таблицы `m_chat`
--

INSERT INTO `m_chat` (`id`, `user_id`, `message`, `cid`, `time`) VALUES
(5, 1, 'test', 0, 1443095027);