<?php
/* 
 * Модель для настройки параметров соединения с БД при установке
 */

class ConfigForm extends CFormModel
{
    public $host;
    public $username;
    public $password;
    public $database;
//    public $prefix;

    /*
     * Файл, в который будем сохранять настройки
     */
    public static $configFile = 'db_connect.ini';



    /*
     * Правила валидации
     */
    public function rules ()
    {
        return array (
            array ('host', 'required',
                'message' => 'Вы не ввели хост сервера БД.'),

            array ('username', 'required',
                'message' => 'Вы не ввели имя пользователя БД.'),

            array ('password', 'required',
                'message' => 'Вы не ввели пароль пользователя БД.'),

            array ('database', 'required',
                'message' => 'Вы не ввели название базы данных.'),

/*
            array ('prefix', 'required',
                'message' => 'Вы не ввели префикс таблиц.'),
 */
        );
    }



    /*
     * Сохранение параметров соединения в ini файл
     */
    public function saveToIniFile ()
    {
        // Загружаем PEAR расширение для работы с ini файлами
        Yii::import ('install.extensions.Config_Lite.*');

        $config = new Config_Lite (Yii::getPathOfAlias ('application.config') . '/' . self::$configFile);

        $config->setString ('db_connect', 'host', $this->host);
        $config->setString ('db_connect', 'username', $this->username);
        $config->setString ('db_connect', 'password', $this->password);
        $config->setString ('db_connect', 'dbname', $this->database);
//        $config->setString ('db_connect', 'tablePrefix', $this->prefix);

        $config->save ();
    }
}