<?php
/* 
 * Модель рекламы для таблицы типа Memory
 */

class AdvMemory extends Adv
{
    /*
     * Период регулярного бекапа данных из таблицы Memory в обычную таблицу
     */
    const BECKUPS_PERIOD = 60;



    /**
     * Returns the static model of the specified AR class.
     * @return Adv the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    /*
     * Имя таблицы
     */
    public function  tableName ()
    {
        return '{{adv_in_memory}}';
    }

    /*
     * Регулярные действия над рекламными ссылками
     */
    public function regularActivities ()
    {
        // При рестарте сервера таблица типа MEMORY очищается,
        // И мы должны заполнить её заново
        if (Yii::app ()->db->createCommand ('SELECT COUNT(*) FROM ' . $this->tableName ())->querySCalar () == 0)
        {
            Yii::app ()->db->createCommand ('INSERT INTO ' . $this->tableName () . ' SELECT * FROM ' . parent::tableName ())->execute ();
        }
        
        // Удаление ссылок с закончившимся сроком действия
        $this->deleteAll ('(`create_date` + `term` * 3600 * 24) < :time AND `term` != 0', array (':time' => time ()));
        $this->deleteAll ('`real_clicks` >= `wanted_clicks` && `wanted_clicks` != 0');

        // Увеличиваем просмотры (Если юзер - не админ)
        if (Yii::app ()->user->isGuest) $this->updateCounters (array ('views' => 1));

        // Через определенные промежутки времени бекапим данные В ОБЫЧНУЮ ТАБЛИЦУ
        if ((time () - Yii::app ()->config->time_last_beckup_adv) > self::BECKUPS_PERIOD)
        {
            // Очищаем обычную таблицу
            Yii::app ()->db->createCommand()->truncateTable (parent::tableName ());
            // И заполняем ее данными из таблицы Memory (то есть текущей)
            Yii::app ()->db->createCommand ('INSERT INTO `' . parent::tableName () . '` SELECT * FROM `' . $this->tableName () . '`')->execute ();
            
            Yii::app ()->config->time_last_beckup_adv = time ();
        }
    }

    /**
     * Загрузка нужных ссылок
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public static function loadLinks ($location)
    {
        $criteria = new CDbCriteria (array (
            'condition' => '`location` = :location',
            'params' => array (':location' => $location)
        ));

        return new CActiveDataProvider(get_class($this), array(
            'criteria' => $criteria,
        ));
    }
}