<?php

/**
 * This is the model class for table "{{comment}}".
 *
 * The followings are the available columns in table '{{comment}}':
 * @property integer $id
 * @property integer $id_post
 * @property integer $id_user
 * @property integer $create_time
 * @property string $login
 * @property string $content
 */
class Comment extends CActiveRecord
{
	/*
         * Имя куков с логином юзера
         */
        const COOKIE_USER = 'cookie_user';

        /*
         * Сколько жить кукам после установки (в секундах)?
         */
        const COOKIE_LIFE = 31536000;// 1 Год



        /*
         * Позиция коммента на странице с комментариями (Применяется при выборе новых комментов)
         */
        public $position;



        /**
	 * Returns the static model of the specified AR class.
	 * @return Comment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{comment}}';
	}

	/*
         * Сохранение системных данных
         */
        public function  beforeSave ()
        {
            $this->ip = Yii::app ()->request->userHostAddress;
            $this->user_agent = Yii::app ()->request->userAgent;

            $this->id_user = (Yii::app ()->user->isGuest) ? 0 : Yii::app ()->user->getModel ()->id;
            if ($this->isNewRecord) $this->create_time = time ();

            // Видел ли админ коммент
            $this->is_see = Yii::app ()->user->isGuest ? 0 : 1;

            return parent::beforeSave ();
        }

        /**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
            return array(
                (!Yii::app ()->user->isGuest) ? array ('login', 'default', 'value' => NULL) :
                array('login', 'required',
                    'message' => 'Вы не ввели логин'),
                array('login', 'length', 'min' => 2, 'max'=>70, 'encoding' => 'utf8',
                    'tooShort' => 'Логин слишком короткий. Минимум 2 символа.',
                    'tooLong' => 'Логин слишком длинный. Максимум 70 символов.'),

                array('content', 'required',
                    'message' => 'Вы не ввели комментарий'),
                array('content', 'length', 'max'=> 10*1024, 'encoding' => 'utf8',
                    'tooLong' => 'Комментарий слишком длинный. Максимум 10 Кб.'),
            );
	}

	/**
	 * @return array Связь с другими таблицами
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    // Информация о пользователе
                    'user' => array (self::BELONGS_TO, 'User', 'id_user'),
                    'post' => array (self::BELONGS_TO, 'Post', 'id_post')
                );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_post' => 'Id Post',
			'id_user' => 'Id User',
			'create_time' => 'Create Time',
			'login' => 'Login',
			'content' => 'Content',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function loadComments ($id)
	{
            $criteria = new CDbCriteria (array (
                'with' => array ('user'),
                'order' => '`create_time` DESC',
                'condition' => '`id_post`=:id_post',
                'params' => array (':id_post' => $id)
            ));

            return new CActiveDataProvider (get_class ($this), array(
            'criteria' => $criteria,
                'pagination' => array (
                    'pageSize' => Yii::app ()->config->page_count_comments
                )
            ));
	}

        /*
         * Число комментариев К СТАТЬЕ
         */
        public function getCommentCount ($id_post)
        {
            return $this->count ('`id_post`=:id_post', array (':id_post' => $id_post));
        }

        /*
         * Последние комментарии
         */
        public function loadLastComments ()
        {
            $criteria=new CDbCriteria (array (
                'with' => array ('user', 'post'),
                /*
                 * Разрешаем конфликт имен столбцов
                 * `t` - псевдоним главной таблицы. В данном случае Comment
                 */
                'order' => '`t` . `create_time` DESC',
                'condition' => (Yii::app ()->user->isGuest) ? '`post` . `status` = "' . Post::STATUS_PUBLISHED . '"' : '',//! без параметров
            ));

            return new CActiveDataProvider(get_class($this), array(
            'criteria'=>$criteria,
                'pagination' => array (
                    'pageSize' => Yii::app ()->config->page_count_comments
                )
            ));
        }

        /*
         * Загрузка непрочитанных комментариев
         */
        public function loadNewComments ()
        {
            /*
            Yii::app ()->db->createCommand ('SET @v1 := 0;')->execute ();
            // Получаем все столбцы данной таблицы
            $attributes = '`' . implode ('`, `', array_keys ($this->attributes)) . '`';
            // Условие запроса (WHERE)
            $condition = ((Yii::app ()->user->isGuest) ? '`post` . `status`=' . Post::STATUS_PUBLISHED . 'AND ' : '') . '`t` . `is_see` = 0';
            
            $dataReader = Yii::app ()->db->createCommand ('SELECT @v1 := (@v1 + 1) AS `position`, ' . $attributes . ' FROM `' . $this->tableName () . '`')->where ($condition)->query ();

            return $dataReader;
             */
            
            Yii::app ()->db->createCommand ('SET @v1 := 0;')->execute ();
            $attributes = '`' . implode ('`, `', array_keys ($this->attributes)) . '`';

            $criteria=new CDbCriteria (array (
                'select' => '@v1 := (@v1 + 1) AS position, ' . $attributes,
                'with' => array ('user', 'post'),
                /*
                 * Разрешаем конфликт имен столбцов
                 * `t` - псевдоним главной таблицы. В данном случае Comment
                 */
                'order' => '`t` . `create_time` DESC',
                'condition' => ((Yii::app ()->user->isGuest) ? '`post` . `status`=' . Post::STATUS_PUBLISHED . 'AND ' : '') . '`t` . `is_see` = 0',
            ));

            return new CActiveDataProvider(get_class($this), array(
            'criteria'=>$criteria,
                'pagination' => array (
                    'pageSize' => Yii::app ()->config->page_count_comments
                )
            ));
        }

        

        /*
         * Обновление статуса видимости админом всех комментов, ВИДИМЫХ НА ТЕКУЩЕЙ СТРАНИЦЕ
         * @param array Массив с идентификаторами статей
         */
        public function updateSeeStatus (array $ids)
        {
            $in = implode (', ', $ids);

            // Запросы на обновление весьма жрут производительность, поэтому перед обновлением проверяем, стоит ли это делать
            if (!Yii::app ()->user->isGuest && $this->find ('`id` IN (' . $in . ') AND `is_see` = 0') != NULL)
            {
                $this->updateAll (array ('is_see' => 1), '`id` IN (' . $in . ')');
            }
        }
}