<?php

/**
 * Модель категории
 */
class Category extends CActiveRecord
{
    /*
     * ID категории с новостями в базе
     */
    const ID_NEWS = 1;



        /**
	 * Returns the static model of the specified AR class.
	 * @return Category the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string Имя таблицы
	 */
	public function tableName()
	{
		return '{{category}}';
	}

        /*
         * Связь с другими таблицами
         */
        public function relations ()
        {
            return array (
                // Количество статей в категории
                'postCount' => array (self::STAT, 'Post', 'id_category')
            );
        }

	/**
	 * @return array Правила валидации
	 */
	public function rules ()
	{
		return array (
                    array ('title', 'required',
                        'message' => 'Вы не ввели название категории'),
                    array ('title', 'length', 'min' => 2, 'max'=>100,
                        'tooShort' => 'Название категории должно быть не короче 2 символов',
                        'tooLong' => 'Название категории должно быть не длиннее 100 символов'),
                    
                    array ('about', 'default', 'value' => NULL),
                    array ('about', 'length', 'max'=>150,
                        'tooLong' => 'Описание категории должно быть не длиннее 150 символов'),
		);
	}

	/**
	 * Загрузка списка категорий
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function loadCategories()
	{
		$criteria = new CDbCriteria (array (
                    // Загружаем все, кроме категории новостей
                    //'condition' => '`id` != :id_news',
                    //'params' => array (':id_news' => self::ID_NEWS),

                    // Количество статей в категории
                    'with' => array (
                        'postCount'
                    ),
                    'order' => '`id` DESC'
                ));
                return new CActiveDataProvider(get_class($this), array(
			'criteria'=>$criteria,
		));
	}
}