<?php
/* 
 * Собственно смайлы
 */

class Smile
{
    /*
     * Папка со смайлами (БЕЗ слеша в конце)
     */
    const FOLDER = '/smiles/ok';

    /*
     * Массив со смайлами
     * Внимание! Коды не должны перекрывать друг друга.
     * То есть ":))" должен идти раньше, чем ":)" или ":DD" раньше, чем ":D" и т.п
     */
    protected static $smiles = array(
        'happy3.gif' => array(':)))', ':-)))', ':))', ':-))'),
        'happy.gif' => array(':)'),
        'sad.gif' => array(':(', ':-('),
        'happy2.gif' => array(':-)'),
        
        'D.gif' => array(':D', ':Д'),
        'DD.gif' => array(':-D', ':-Д'),
        'mignul.gif' => array(';)', ';-)'),
        'vopros.gif' => array(':?:', ':vopros:', ':вопрос:'),
        'hack.gif' => array(':hack:'),
        'nozh.gif' => array (':nozh:', ':kill:', ':die:'),
        'xmm.gif' => array(';/', ':xmm:', ':хмм:'),

        'kulak.gif' => array(':kulak:', ':кулак:', ':кыш:'),
        'patstulom.gif' => array(':podstulom:', ':patstulom:', ':patstulam:'),
        'over_look_kapitan.png' => array(':fp:', ':kapitan:', ':kap:', ':ko:', ':KO:'),
        'fp.gif' => array(':fp2:', ':facepalm:', ':face_palm:'),
        'trollface.png' => array(':trollface:', ':тролль:'),
        'bleat.png' => array (':bleat:', ':muzhig:', ':блеать:', ':мужик:', ':мужиг:'),
        'heart.gif' => array(':heart:', ':сердце:'),
        'boyan.gif' => array(':boyan:', ':боян:'),
        'stena.gif' => array(':stena:', ':стена:'),
        'benzopila.gif' => array(':benzopila:', ':бензопила:'),
        'super.gif' => array(':super:', ':супер:'),
        
        'ban.gif' => array(':ban:', ':бан:'),
        'crazy_ban.gif' => array(':crazy_ban:'),
        'censored.gif' => array(':censored:'),
        'google.gif' => array(':google:', ':гугл:'),
        'jjot.gif' => array(':avtor:', ':aftar:', ':afftar:', ':автор:', ':афтар:', ':аффтар:'),
        'yakrut.gif' => array(':yakrut:', ':я крут:'),
        'lol.gif' => array(':lol:', ':лол:'),
            //'' => array ('', ''),
            //'' => array ('', ''),
            //'' => array ('', ''),
            //'' => array ('', ''),
            //'' => array ('', ''),
            //'' => array ('', ''),
            //'' => array ('', ''),
            //'' => array ('', ''),
            //'' => array ('', ''),
            //'' => array ('', ''),
    );

    /*
     * Отдаем массив со смайлами
     */
    public static function Get ()
    {
        return self::$smiles;
    }

    /*
     * Форматирование исходного текста и замена кодов картинками
     */
    public static function Format ($str)
    {
        foreach (self::$smiles as $image => $codeMass)
        {
            $str = str_replace ($codeMass, '<img src="' . Yii::app ()->request->getBaseUrl (TRUE) . self::FOLDER . '/' . $image . '" alt="smile" />', $str);
        }

        return $str;
    }
}