<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity
{
	/*
         * ID юзера
         */
        private $_id;

        

        /**
	 * Authenticates a user.
	 * @return boolean whether authentication succeeds.
	 */
	public function authenticate()
	{
                strtolower ($this->username);
                $user = User::model ()->find ('`login` = ?', array ($this->username));
                
                if ($user === NULL)
                    $this->errorCode = self::ERROR_USERNAME_INVALID;
                elseif (!$user->validatePassword ($this->password))
                    $this->errorCode = self::ERROR_PASSWORD_INVALID;
                else
                {
                    $this->_id = $user->id;
                    $this->errorCode = self::ERROR_NONE;
                }
                return $this->errorCode == self::ERROR_NONE;
	}

        /*
         * Возвращает ID юзера
         */
        public function getId ()
        {
            return $this->_id;
        }
}