<?php
/* 
 * Класс для рекурсивного удаления каталога
 * Требует SPL
 * SPL есть в PHP > 5.0.0
 */

class rmDir
{
    public static function delete ($dir)
    {
        $items = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir), RecursiveIteratorIterator::CHILD_FIRST);
        // Проходим по каталогу и удаляем его содержимое
        foreach($items as $item)
        {
            if ($item->isDir())
                rmdir($item->getRealPath());
            else
                unlink($item->getRealPath());
        }
        // А теперь удаляем и сам каталог
        rmdir ($dir);
    }
}