<?php

/**
 * This is the model class for table "{{adv}}".
 *
 * The followings are the available columns in table '{{adv}}':
 * @property integer $id
 * @property string $url
 * @property string $title
 * @property integer $term
 * @property integer $create_date
 * @property string $color
 * @property integer $is_bold
 */
class Adv extends CActiveRecord
{

    /*
     * Расположение рекламы. СВЕРХУ
     */
    const LOCATION_TOP = 'top';

    /*
     * Расположение рекламы. СНИЗУ
     */
    const LOCATION_BOTTOM = 'bottom';



    /**
     * Returns the static model of the specified AR class.
     * @return Adv the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName ()
    {
        return '{{adv}}';
    }

    /*
     * Сохранение системных данных
     */
    public function  beforeSave() {
        if ($this->isNewRecord) $this->create_date = time ();
        
        return parent::beforeSave();
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array ('name, url, titles, term, location', 'required'),
            
            array ('name', 'length', 'max' => 100, 'encoding' => 'utf8'),
            array ('url', 'match', 'pattern' => '#^(http://|https://|ftp://)\S+$#uim'),
            array ('url', 'length', 'max' => 100, 'encoding' => 'utf8'),

            array ('titles', 'length', 'max' => 300, 'encoding' => 'utf8'),

            array ('term', 'numerical', 'integerOnly' => TRUE, 'min' => 0, 'max' => 100),
            array ('wanted_clicks', 'numerical', 'integerOnly' => TRUE, 'min' => 0),

            array ('location', 'in', 'range' => array (self::LOCATION_TOP, self::LOCATION_BOTTOM)),

            array ('is_explicit', 'boolean'),
        );
    }

    /*
     * Действия после валидации
     *
     * Делаем дополнительную валидацию
     */
    public function  afterValidate() {
        if ($this->term != 0 && $this->wanted_clicks != 0)
                $this->addError ('term', 'Нельзя ограничивать сразу и по сроку и по переходам! Используйте что-то одно.');

        parent::afterValidate();
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'name' => 'Имя ссылки',
            'url' => 'URL',
            'titles' => 'Названия ссылки',
            'create_date' => 'Create Date',
            'term' => 'Срок',
            'location' => 'Место',
            'is_explicit' => 'Прямая ли ссылка',
            'wanted_clicks' => 'Максимальное число переходов'
        );
    }

}