<?php

/**
 * This is the model class for table "{{static_page}}".
 *
 * The followings are the available columns in table '{{static_page}}':
 * @property integer $id
 * @property string $title
 * @property string $content
 * @property string $key_words
 * @property string $description
 * @property integer $is_delete
 */
class StaticPage extends CActiveRecord {

    /*
     * ИД страницы "Обо мне" в бд.
     */
    const ID_ABOUT = 1;



    /**
     * Returns the static model of the specified AR class.
     * @return StaticPage the static model class
     */
    public static function model($className=__CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{static_page}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('title', 'required',
                'message' => 'Вы не ввели заголовок страницы'),
            array('content', 'required',
                'message' => 'Вы не ввели содержание страницы'),
            
            array('title, key_words, description', 'length', 'max' => 200, 'encoding' => 'utf8'),
            array('content', 'length', 'max' => 100 * 1024, 'encoding' => 'utf8',
                'message' => 'Содержание страницы не должно превышать 100 килобайт'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'title' => 'Заголовок',
            'content' => 'Содержание',
            'key_words' => 'Ключевые слова',
            'description' => 'Описание',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function loadPages () {
        $criteria = new CDbCriteria;
        return new CActiveDataProvider(get_class($this), array(
            'criteria' => $criteria,
        ));
    }

}