<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');
// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.

// Узнаем, установлено ли приложение
define ('IS_INSTALL', (file_exists ('install.php')) ? FALSE : TRUE);

if (IS_INSTALL) $db = parse_ini_file ('db_connect.ini');
//$db = parse_ini_file ('db_connect.ini');

return array(
    'basePath' => dirname (__FILE__) . DIRECTORY_SEPARATOR . '..',

    'name' => 'Fresh Blog',
    'language' => 'ru',
    'defaultController' => 'index',

    //'theme' => 'green_promo',// Тема будет переопределена в ходе действий контроллера
    'theme' => 'free4blog',

    // preloading 'log' component
    'preload' => array('log'),
    // autoloading model and component classes
    'import' => array(
        'application.models.*',
        'application.components.*',
        'application.widgets.*',
        'ext.*',
        'application.modules.adv.models.*'// Модели рекламы
    ),

    'modules' => array(
        // uncomment the following to enable the Gii tool

        //'install',  // Установщик
        'adv',      // Менеджер рекламы
    ),
    
    // application components
    'components' => array(
        'config' => array (// Система настроек
            'class' => 'Config'
        ),
        'user' => array(
            // enable cookie-based authentication
            'allowAutoLogin' => true,
            'class' => 'WebUser',
            // Ссылка, куда будет перенаправляться пользователь при запрете доступа
            'loginUrl' => array('login')
        ),

        // uncomment the following to enable URLs in path-format
        // Активируем красивые url'ы =)
        'urlManager' => array(
            'urlFormat' => 'path',
            'rules' => array(
                // Запрос вида tag/param воспринимается как поиск определенного тега, а tags/param как выполнение действия
                'tag/<tag>' => 'tag/view',                              // Для приятной юзеру ссылки на тег
                'tags/<action:\w+>' => 'tag/<action>',                  // Во избежание конфликта тегов с именами методов
                'rss/tag/<tag>' => 'rss/tag',                           // Для приятной юзеру ссылки на RSS ленту с данным тегом

                // Делаем по-красивее навигационные url'ы на главной
                '<Post_page:\d+>' => 'index/index',
                '' => 'index/index',                                    // Из-за особенностей навигации

                'post<id:\d+>.html' => 'post/view',                     // Поисковые роботы любят такие урлы)
                'static<id:\d+>.html' => 'staticPage/view',             // Поисковые роботы любят такие урлы)
                'export/post<id:\d+>.<action>' => 'export/<action>',    // Поисковые роботы любят такие урлы)

                'rss.xml' => 'rss',                                     // А такие - новостные агрегаторы =)
                'rss/<action><id:\d+>.xml' => 'rss/<action>',           // А такие - новостные агрегаторы =)
                'rss/<action>.xml' => 'rss/<action>',                   // А такие - новостные агрегаторы =)

                'go/<id:\d+>' => '//adv/default/go',                    // Рекламные ссылки



                // Стандартные правила. Не трогать!
                '<controller:\w+>/<id:\d+>' => '<controller>/view',
                '<controller:\w+>/<action:\w+>/<id:\d+>' => '<controller>/<action>',
                '<controller:\w+>/<action:\w+>' => '<controller>/<action>',
            ),
            'showScriptName' => FALSE // Скрываем index.php
        ),

        /* 'db'=>array(
          'connectionString' => 'sqlite:'.dirname(__FILE__).'/../data/testdrive.db',
          ), */
        // uncomment the following to use a MySQL database

        'db' => array(
            'connectionString' => 'mysql:host=' . $db["host"] . ';dbname=' . $db["dbname"],
            'emulatePrepare' => true,
            'username' => $db["username"],
            'password' => $db["password"],
            'charset' => 'utf8',
            'tablePrefix' => $db["tablePrefix"],
            'enableProfiling' => TRUE,

            'autoConnect' => FALSE,// Во избежание автоподключения
            // Включаем кэширование схемы БД (схема БД требуется для Active Record)
            // Включить кэширование схем для улучшения производительности
            'schemaCachingDuration' => 3600,

        ),
        
        /*
          'errorHandler'=>array(
          // use 'site/error' action to display errors
          'errorAction'=>'site/error',
          ), */

        'log' => array(
            'class' => 'CLogRouter',
            'routes' => array(
                array(
                    'class' => 'CFileLogRoute',
                    'levels' => 'error, warning',
                ),
                /*
                array(
                    'class' => 'CProfileLogRoute'
                ),
            // uncomment the following to show log messages on web pages
            /*
              array(
              'class'=>'CWebLogRoute',
              ),
             */
            ),
        ),
    ),
    // application-level parameters that can be accessed
    // using Yii::app()->params['paramName']
    'params' => array(
        // this is used in contact page
        'adminEmail' => 'webmaster@example.com',
    ),
);