<?php
/* 
 * Добавляем функционал в компонент User
 *
 * Добавлен метод получения модели юзера, потому что:
 * 1. При сохранении информации с помощью UserIdentity::setState, она сохраняется в сессиях (или даже куках), что чревато
 *      1. НЕбезопасностью хранения данных
 *      2. Расходованием лишнего места на сервере
 * 2. При изменении модели придется менять соответствующие setState в UserIdentity
 * 3. Недостоверностью данных. Куки могут быть изменены в любой момент
 */

class WebUser extends CWebUser
{
    /*
     * Здесь будет храниться экземпляр модели
     */
    private $_model = NULL;

    /*
     * Получаем экземпляр МОДЕЛИ User
     */
    public function getModel ()
    {
        if (!$this->isGuest && $this->_model === NULL)
                $this->_model = User::model ()->findByPk ($this->id);
        return $this->_model;
    }
}