/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class StatementList
extends List
implements CommandListener {
    Calculator calculator;
    static Image[] states = new Image[3];

    StatementList(Calculator calculator) {
        super("Statements", 3);
        this.calculator = calculator;
        Vector vector = calculator.statements;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Calculator.Statement statement = (Calculator.Statement)vector.elementAt(i);
            this.append(statement.text, states[statement.state]);
        }
        this.setCommandListener(this);
        this.addCommand(Calculator.BACK_CMD);
        this.addCommand(Calculator.EDIT_CMD);
        this.addCommand(Calculator.DELETE_CMD);
        this.addCommand(Calculator.NEW_CMD);
        this.addCommand(Calculator.INS_CMD);
        Display.getDisplay((MIDlet)calculator).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Calculator.BACK_CMD) {
            Display.getDisplay((MIDlet)this.calculator).setCurrent((Displayable)this.calculator.mainMenu);
        } else {
            int n = this.getSelectedIndex();
            if (n >= 0) {
                if (command == Calculator.DELETE_CMD) {
                    if (this.calculator.statements.size() == 1) {
                        this.set(n, "", null);
                    } else {
                        this.delete(n);
                    }
                    this.calculator.removeStatement(n);
                } else if (command == Calculator.NEW_CMD) {
                    this.calculator.newStatement();
                    Display.getDisplay((MIDlet)this.calculator).setCurrent((Displayable)this.calculator.mainMenu);
                } else if (command == Calculator.INS_CMD) {
                    String string = ((Calculator.Statement)this.calculator.statements.elementAt((int)n)).text;
                    int n2 = string.indexOf(40);
                    if (n2 < 0 || string.indexOf(61) < n2) {
                        this.calculator.showAlert(AlertType.ERROR, "Error", "Statement is not a function");
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append('(');
                        if (string.charAt(n2) != '=' && string.charAt(n2) == ',') {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(')');
                        this.calculator.insertText(string.substring(0, n2) + stringBuffer);
                        Display.getDisplay((MIDlet)this.calculator).setCurrent((Displayable)this.calculator.mainMenu);
                    }
                } else {
                    this.calculator.editStatement(n);
                    Display.getDisplay((MIDlet)this.calculator).setCurrent((Displayable)this.calculator.mainMenu);
                }
            }
        }
    }

    static {
        try {
            StatementList.states[0] = Image.createImage((String)"/unknown.png");
            StatementList.states[1] = Image.createImage((String)"/compiled.png");
            StatementList.states[2] = Image.createImage((String)"/error.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

