/*
 * Decompiled with CFR 0.152.
 */
package org.qcontinuum.compass;

import henson.midp.Float;
import java.util.Date;
import org.qcontinuum.astro.Astrometric;
import org.qcontinuum.astro.EarthHeading;
import org.qcontinuum.astro.EarthPosition;
import org.qcontinuum.astro.EclipticPosition;
import org.qcontinuum.astro.EquitorialPosition;
import org.qcontinuum.astro.HorizontalPosition;
import org.qcontinuum.astro.UtcDate;
import org.qcontinuum.compass.Compass;
import org.qcontinuum.compass.Location;
import org.qcontinuum.compass.Preferences;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SunMoonPosition {
    private UtcDate a;
    private HorizontalPosition a;
    private HorizontalPosition b;
    private Float a;
    private EarthHeading a;

    public SunMoonPosition(Date date) {
        this(date, Compass.getPreferences().getLocation());
    }

    public SunMoonPosition(Date date, Location location) {
        Date date2 = location.getGmt(date);
        this.a = new UtcDate(date2);
        EarthPosition earthPosition = location.getEarthPosition();
        Float float_ = this.a.getMJD();
        EclipticPosition eclipticPosition = Astrometric.sunPosition(float_);
        EquitorialPosition equitorialPosition = eclipticPosition.toEquitorialPosition();
        this.a = equitorialPosition.toHorizontalPosition(earthPosition, float_);
        EclipticPosition eclipticPosition2 = Astrometric.moonPosition(float_);
        EquitorialPosition equitorialPosition2 = eclipticPosition2.toEquitorialPosition();
        this.b = equitorialPosition2.toHorizontalPosition(earthPosition, float_);
        Float float_2 = eclipticPosition.getLongitude().Sub(eclipticPosition2.getLongitude());
        this.a = Float.cos(Float.PI.Sub(float_2)).Add(new Float(1L)).Div(new Float(2L));
        Preferences preferences = Compass.getPreferences();
        if (preferences.getDestination() == null) {
            this.a = null;
            return;
        }
        this.a = earthPosition.toEarthHeading(preferences.getDestination().getEarthPosition());
    }

    public UtcDate getUtcDate() {
        return this.a;
    }

    public HorizontalPosition getSunPosition() {
        return this.a;
    }

    public HorizontalPosition getMoonPosition() {
        return this.b;
    }

    public Float getMoonPhase() {
        return this.a;
    }

    public EarthHeading getDestinationHeading() {
        return this.a;
    }
}

