/*
 * Decompiled with CFR 0.152.
 */
package org.qcontinuum.compass;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import org.qcontinuum.astro.EarthPosition;
import org.qcontinuum.compass.TimeZone;

public class Location {
    public String Name;
    public String AirportCode;
    public short LatMinutes;
    public short LongMinutes;
    public TimeZone timeZone;
    public boolean dstEnabled;

    public Location() {
        this.dstEnabled = true;
    }

    public Location(Location location) {
        this.Name = location.Name;
        this.AirportCode = location.AirportCode;
        this.LatMinutes = location.LatMinutes;
        this.LongMinutes = location.LongMinutes;
        this.timeZone = location.timeZone == null ? null : new TimeZone(location.timeZone);
        this.dstEnabled = location.dstEnabled;
    }

    public Location(String string) {
        this.Name = string;
        this.a();
    }

    public Location(DataInputStream dataInputStream) throws IOException {
        this.load(dataInputStream);
    }

    public Location(String string, int n, int n2) {
        this.Name = string;
        this.AirportCode = null;
        this.LatMinutes = (short)n;
        this.LongMinutes = (short)n2;
        this.timeZone = null;
        this.dstEnabled = false;
    }

    public EarthPosition getEarthPosition() {
        return new EarthPosition(this.LatMinutes, this.LongMinutes);
    }

    public Date getGmt(Date date) {
        return this.timeZone.getGmt(date, this.dstEnabled);
    }

    public Date getLocalTime(Date date) {
        return this.timeZone.getLocalTime(date, this.dstEnabled);
    }

    public int getStdOffset() {
        return this.timeZone.getStdOffset();
    }

    public int getDstOffset(Date date) {
        return this.timeZone.getDstOffset(date, this.dstEnabled);
    }

    public void load(String string) {
        this.Name = string;
        this.a();
    }

    private void a() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)this.Name, (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.load(dataInputStream);
            dataInputStream.close();
            recordStore.closeRecordStore();
            return;
        }
        catch (Exception exception) {
            this.AirportCode = null;
            this.Name = null;
            this.LongMinutes = 0;
            this.LatMinutes = 0;
            this.timeZone = new TimeZone();
            return;
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.Name = Location.b(dataInputStream.readUTF());
        this.AirportCode = Location.b(dataInputStream.readUTF());
        this.LatMinutes = dataInputStream.readShort();
        this.LongMinutes = dataInputStream.readShort();
        this.timeZone = dataInputStream.readBoolean() ? new TimeZone(dataInputStream) : null;
        this.dstEnabled = dataInputStream.readBoolean();
    }

    public void save() {
        RecordStore recordStore;
        try {
            recordStore = RecordStore.openRecordStore((String)this.Name, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.save(dataOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
            dataOutputStream.close();
            recordStore.closeRecordStore();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(Location.a(this.Name));
        dataOutputStream.writeUTF(Location.a(this.AirportCode));
        dataOutputStream.writeShort(this.LatMinutes);
        dataOutputStream.writeShort(this.LongMinutes);
        dataOutputStream.writeBoolean(this.timeZone != null);
        if (this.timeZone != null) {
            this.timeZone.save(dataOutputStream);
        }
        dataOutputStream.writeBoolean(this.dstEnabled);
    }

    private static String a(String string) {
        if (string != null) {
            return string;
        }
        return "";
    }

    private static String b(String string) {
        if (string.length() > 0) {
            return string;
        }
        return null;
    }
}

